/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa;

import com.codahale.metrics.health.HealthCheck;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import io.dropwizard.jackson.Jackson;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.util.Duration;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.sdase.commons.server.opa.OpaJwtPrincipal;
import org.sdase.commons.server.opa.config.OpaClientConfiguration;
import org.sdase.commons.server.opa.config.OpaConfig;
import org.sdase.commons.server.opa.config.OpaConfigProvider;
import org.sdase.commons.server.opa.extension.OpaInputExtension;
import org.sdase.commons.server.opa.extension.OpaInputHeadersExtension;
import org.sdase.commons.server.opa.filter.OpaAuthFilter;
import org.sdase.commons.server.opa.filter.model.OpaInput;
import org.sdase.commons.server.opa.health.PolicyExistsHealthCheck;
import org.sdase.commons.server.opa.internal.OpaJwtPrincipalFactory;
import org.sdase.commons.server.opentracing.client.ClientTracingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpaBundle<T extends Configuration>
implements ConfiguredBundle<T> {
    private static final Logger LOG = LoggerFactory.getLogger(OpaBundle.class);
    private final OpaConfigProvider<T> configProvider;
    private final Map<String, OpaInputExtension<?>> inputExtensions;
    private final Tracer tracer;

    private OpaBundle(OpaConfigProvider<T> configProvider, Map<String, OpaInputExtension<?>> inputExtensions, Tracer tracer) {
        this.configProvider = configProvider;
        this.inputExtensions = inputExtensions;
        this.tracer = tracer;
    }

    public static ProviderBuilder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public Map<String, OpaInputExtension<?>> getInputExtensions() {
        return this.inputExtensions;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(T configuration, Environment environment) {
        OpaConfig config = (OpaConfig)this.configProvider.apply(configuration);
        if (config.isDisableOpa()) {
            LOG.warn("Authorization is disabled. This setting should NEVER be used in production.");
        }
        Tracer currentTracer = this.tracer == null ? GlobalTracer.get() : this.tracer;
        ObjectMapper objectMapper = this.createObjectMapper();
        Client client = this.createClient(environment, config, objectMapper, currentTracer);
        WebTarget policyTarget = client.target(this.buildUrl(config));
        ArrayList<String> excludePattern = new ArrayList<String>();
        if (this.excludeSwagger()) {
            excludePattern.addAll(this.getSwaggerExcludePatterns());
        }
        if (this.excludeOpenApi()) {
            excludePattern.addAll(this.getOpenApiExcludePatterns());
        }
        environment.jersey().register((Object)new OpaAuthFilter(policyTarget, config, excludePattern, objectMapper, this.inputExtensions, currentTracer));
        if (!config.isDisableOpa()) {
            environment.healthChecks().register("OpenPolicyAgent", (HealthCheck)new PolicyExistsHealthCheck(policyTarget));
        }
        environment.jersey().register((Object)new AbstractBinder(){

            protected void configure() {
                this.bindFactory(OpaJwtPrincipalFactory.class).to(OpaJwtPrincipal.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
            }
        });
    }

    private Client createClient(Environment environment, OpaConfig config, ObjectMapper objectMapper, Tracer tracer) {
        OpaClientConfiguration clientConfig;
        OpaClientConfiguration opaClientConfiguration = clientConfig = config.getOpaClient() == null ? new OpaClientConfiguration() : config.getOpaClient();
        if (config.getReadTimeout() != null) {
            clientConfig.setTimeout(Duration.milliseconds((long)config.getReadTimeout().intValue()));
        }
        Client client = new JerseyClientBuilder(environment).using((JerseyClientConfiguration)clientConfig).using(objectMapper).build("opaClient");
        ClientTracingUtil.registerTracing((Client)client, (Tracer)tracer);
        return client;
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = Jackson.newObjectMapper();
        objectMapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES).disable(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        return objectMapper;
    }

    private List<String> getSwaggerExcludePatterns() {
        return Lists.newArrayList((Object[])new String[]{"swagger\\.(json|yaml)"});
    }

    private boolean excludeSwagger() {
        try {
            if (this.getClass().getClassLoader().loadClass("org.sdase.commons.server.swagger.SwaggerBundle") != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private List<String> getOpenApiExcludePatterns() {
        return Lists.newArrayList((Object[])new String[]{"openapi\\.(json|yaml)"});
    }

    private boolean excludeOpenApi() {
        try {
            if (this.getClass().getClassLoader().loadClass("org.sdase.commons.server.openapi.OpenApiBundle") != null) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    private String buildUrl(OpaConfig config) {
        return String.format("%s/v1/data/%s", config.getBaseUrl(), config.getPolicyPackagePath());
    }

    public static class DuplicatePropertyException
    extends RuntimeException {
        public DuplicatePropertyException(String namespace, OpaInputExtension<?> extension, OpaInputExtension<?> alreadyRegisteredExtension) {
            super(String.format("There is already an extension \"%s\" registered for the field \"%s\". The extension \"%s\" would override this field.", alreadyRegisteredExtension.getClass().getName(), namespace, extension.getClass().getName()));
        }
    }

    public static class HiddenOriginalPropertyException
    extends RuntimeException {
        public HiddenOriginalPropertyException(String namespace, OpaInputExtension<?> extension) {
            super(String.format("The extension \"%s\" would override the original field \"%s\" of the OpaInput. This is not allowed!", extension.getClass().getName(), namespace));
        }
    }

    public static class Builder<C extends Configuration>
    implements ProviderBuilder,
    OpaExtensionsBuilder<C>,
    OpaBuilder<C> {
        private OpaConfigProvider<C> opaConfigProvider;
        private Tracer tracer;
        private final Map<String, OpaInputExtension<?>> inputExtensions = new HashMap();
        private boolean addHeadersExtension = true;

        private Builder() {
        }

        private Builder(OpaConfigProvider<C> opaConfigProvider) {
            this.opaConfigProvider = opaConfigProvider;
        }

        public <T extends Configuration> OpaExtensionsBuilder<T> withOpaConfigProvider(OpaConfigProvider<T> opaConfigProvider) {
            return new Builder<T>(opaConfigProvider);
        }

        @Override
        public OpaExtensionsBuilder<C> withoutHeadersExtension() {
            this.addHeadersExtension = false;
            return this;
        }

        @Override
        public <T> OpaBuilder<C> withInputExtension(String namespace, OpaInputExtension<T> extension) {
            if (Arrays.stream(OpaInput.class.getDeclaredFields()).anyMatch(f -> f.getName().equals(namespace))) {
                throw new HiddenOriginalPropertyException(namespace, extension);
            }
            if (this.inputExtensions.containsKey(namespace)) {
                throw new DuplicatePropertyException(namespace, extension, this.inputExtensions.get(namespace));
            }
            this.inputExtensions.put(namespace, extension);
            return this;
        }

        @Override
        public OpaBuilder<C> withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        @Override
        public OpaBundle<C> build() {
            if (this.addHeadersExtension) {
                this.withInputExtension("headers", OpaInputHeadersExtension.builder().build());
            }
            return new OpaBundle(this.opaConfigProvider, this.inputExtensions, this.tracer);
        }
    }

    public static interface OpaBuilder<C extends Configuration> {
        public <T> OpaBuilder<C> withInputExtension(String var1, OpaInputExtension<T> var2);

        public OpaBuilder<C> withTracer(Tracer var1);

        public OpaBundle<C> build();
    }

    public static interface OpaExtensionsBuilder<C extends Configuration>
    extends OpaBuilder<C> {
        public OpaExtensionsBuilder<C> withoutHeadersExtension();
    }

    public static interface ProviderBuilder {
        public <C extends Configuration> OpaExtensionsBuilder<C> withOpaConfigProvider(OpaConfigProvider<C> var1);
    }
}

