/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa.filter;

import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.NotImplementedException;
import org.sdase.commons.server.auth.JwtPrincipal;
import org.sdase.commons.server.opa.OpaJwtPrincipal;
import org.sdase.commons.server.opa.config.OpaConfig;
import org.sdase.commons.server.opa.extension.OpaInputExtension;
import org.sdase.commons.server.opa.filter.model.OpaInput;
import org.sdase.commons.server.opa.filter.model.OpaRequest;
import org.sdase.commons.server.opa.filter.model.OpaResponse;
import org.sdase.commons.server.opa.internal.OpaJwtPrincipalImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=2000)
public class OpaAuthFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(OpaAuthFilter.class);
    private final WebTarget webTarget;
    private final boolean isDisabled;
    private final List<Pattern> excludePatterns;
    private final ObjectMapper om;
    private final Map<String, OpaInputExtension<?>> inputExtensions;
    private final Tracer tracer;

    public OpaAuthFilter(WebTarget webTarget, OpaConfig config, List<String> excludePatterns, ObjectMapper om, Map<String, OpaInputExtension<?>> inputExtensions, Tracer tracer) {
        this.webTarget = webTarget;
        this.isDisabled = config.isDisableOpa();
        this.excludePatterns = excludePatterns == null ? Collections.emptyList() : excludePatterns.stream().map(Pattern::compile).collect(Collectors.toList());
        this.om = om;
        this.inputExtensions = inputExtensions;
        this.tracer = tracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext) {
        Span span = this.tracer.buildSpan("authorizeUsingOpa").withTag("opa.allow", false).withTag((Tag)Tags.COMPONENT, (Object)"OpaAuthFilter").start();
        try (Scope ignored = this.tracer.scopeManager().activate(span);){
            JwtPrincipal jwtPrincipal;
            UriInfo uriInfo = requestContext.getUriInfo();
            String method = requestContext.getMethod();
            String trace = requestContext.getHeaderString("Trace-Token");
            String jwt = null;
            SecurityContext securityContext = requestContext.getSecurityContext();
            Map<String, Claim> claims = null;
            if (null != securityContext && (jwtPrincipal = this.getJwtPrincipal(requestContext.getSecurityContext())) != null) {
                jwt = jwtPrincipal.getJwt();
                claims = jwtPrincipal.getClaims();
            }
            JsonNode constraints = null;
            if (!this.isDisabled && !this.isExcluded(uriInfo)) {
                String[] path = (String[])uriInfo.getPathSegments().stream().map(PathSegment::getPath).toArray(String[]::new);
                OpaInput opaInput = new OpaInput(jwt, path, method, trace);
                ObjectNode objectNode = (ObjectNode)this.om.convertValue((Object)opaInput, ObjectNode.class);
                this.inputExtensions.forEach((namespace, extension) -> objectNode.set(namespace, this.om.valueToTree(extension.createAdditionalInputContent(requestContext))));
                OpaRequest request = OpaRequest.request((JsonNode)objectNode);
                constraints = this.authorizeWithOpa(request, span);
            }
            OpaJwtPrincipalImpl principal = OpaJwtPrincipal.create(jwt, claims, constraints, this.om);
            this.replaceSecurityContext(requestContext, securityContext, principal);
        }
        finally {
            span.finish();
        }
    }

    private boolean isExcluded(UriInfo uriInfo) {
        return this.excludePatterns.stream().anyMatch(p -> p.matcher(uriInfo.getPath()).matches());
    }

    private void replaceSecurityContext(ContainerRequestContext requestContext, SecurityContext securityContext, final OpaJwtPrincipal principal) {
        final boolean secure = securityContext != null && securityContext.isSecure();
        final String scheme = securityContext != null ? securityContext.getAuthenticationScheme() : "unknown";
        requestContext.setSecurityContext(new SecurityContext(){

            public Principal getUserPrincipal() {
                return principal;
            }

            public boolean isUserInRole(String role) {
                throw new NotImplementedException("The isUserInRole methods is not supported for OpaJwtPrincipal");
            }

            public boolean isSecure() {
                return secure;
            }

            public String getAuthenticationScheme() {
                return scheme;
            }
        });
    }

    private JsonNode authorizeWithOpa(OpaRequest request, Span span) {
        OpaResponse resp = null;
        try {
            resp = (OpaResponse)this.webTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json((Object)request), OpaResponse.class);
        }
        catch (WebApplicationException e) {
            try {
                e.getResponse().close();
            }
            catch (ProcessingException ex) {
                LOG.warn("Error while closing response", (Throwable)ex);
            }
            LOG.warn("Exception when querying OPA. Maybe policy is broken", (Throwable)e);
        }
        catch (ProcessingException e) {
            LOG.warn("Exception during processing of OPA request.", (Throwable)e);
        }
        if (null == resp || resp.getResult() == null) {
            LOG.warn("Invalid response from OPA. Maybe the policy path or the response format is not correct");
            throw new ForbiddenException("Not authorized");
        }
        span.setTag("opa.allow", resp.isAllow());
        if (!resp.isAllow()) {
            throw new ForbiddenException("Not authorized");
        }
        if (null == resp.getResult()) {
            return null;
        }
        return resp.getResult();
    }

    private JwtPrincipal getJwtPrincipal(SecurityContext securityContext) {
        Principal principal = securityContext.getUserPrincipal();
        return principal instanceof JwtPrincipal ? (JwtPrincipal)principal : null;
    }
}

