/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa.health;

import com.codahale.metrics.health.HealthCheck;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.sdase.commons.server.opa.filter.model.OpaResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyExistsHealthCheck
extends HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyExistsHealthCheck.class);
    public static final String DEFAULT_NAME = "OpenPolicyAgent";
    private final WebTarget client;

    public PolicyExistsHealthCheck(WebTarget client) {
        this.client = client;
    }

    public HealthCheck.Result check() {
        try {
            OpaResponse opaResponse = (OpaResponse)this.client.request().post(Entity.json(null), OpaResponse.class);
            if (opaResponse == null || opaResponse.getResult() == null || opaResponse.getResult().isNull()) {
                LOGGER.warn("The policy response seems not to be SDA guideline compliant");
                return HealthCheck.Result.unhealthy((String)"The policy response seems not to be SDA guideline compliant");
            }
            if (opaResponse.isAllow()) {
                LOGGER.warn("The policy should respond with a deny decision by default");
                return HealthCheck.Result.unhealthy((String)"The policy should respond with a deny decision by default");
            }
            return HealthCheck.Result.healthy();
        }
        catch (Exception e) {
            LOGGER.warn("Failed health check", (Throwable)e);
            return HealthCheck.Result.unhealthy((String)e.getMessage());
        }
    }
}

