/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.opa.internal;

import com.auth0.jwt.interfaces.Claim;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.sdase.commons.server.opa.OpaJwtPrincipal;

public class OpaJwtPrincipalImpl
implements OpaJwtPrincipal {
    private String name;
    private String jwt;
    private Map<String, Claim> claims;
    private JsonNode constraints;
    private ObjectMapper om;

    public OpaJwtPrincipalImpl(String name, String jwt, Map<String, Claim> claims, JsonNode constraints, ObjectMapper om) {
        this.name = name;
        this.jwt = jwt;
        this.claims = claims;
        this.constraints = constraints;
        this.om = om;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getJwt() {
        return this.jwt;
    }

    @Override
    public Map<String, Claim> getClaims() {
        return this.claims;
    }

    @Override
    public String getConstraints() {
        return this.constraints.toString();
    }

    @Override
    public <T> T getConstraintsAsEntity(Class<T> resultType) {
        if (this.constraints != null) {
            return (T)this.om.convertValue((Object)this.constraints, resultType);
        }
        return null;
    }
}

