/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.hibernate;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.db.PooledDataSourceFactory;
import io.dropwizard.hibernate.ScanningHibernateBundle;
import io.dropwizard.hibernate.SessionFactoryFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.Validate;
import org.hibernate.SessionFactory;
import org.sdase.commons.server.hibernate.DatabaseConfigurationProvider;
import org.sdase.commons.server.hibernate.NonScanningHibernateBundle;

public class HibernateBundle<C extends Configuration>
implements ConfiguredBundle<C> {
    private static final String POSTGRES_DRIVER_CLASS = "org.postgresql.Driver";
    private static final Map<String, String> DEFAULT_PROPERTIES = HibernateBundle.initDefaultProperties();
    private io.dropwizard.hibernate.HibernateBundle<C> delegate;

    private static Map<String, String> initDefaultProperties() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put("charSet", "UTF-8");
        defaults.put("hibernate.dialect", "org.hibernate.dialect.PostgreSQLDialect");
        defaults.put("currentSchema", "public");
        return defaults;
    }

    private HibernateBundle(Set<String> packagesToScanForEntities, final DatabaseConfigurationProvider<C> configurationProvider) {
        String[] packagesToScan = packagesToScanForEntities.toArray(new String[0]);
        this.delegate = new ScanningHibernateBundle<C>(packagesToScan, new SessionFactoryFactory()){

            public PooledDataSourceFactory getDataSourceFactory(C configuration) {
                DataSourceFactory database = (DataSourceFactory)configurationProvider.apply(configuration);
                HibernateBundle.this.applyDefaultSettings(database);
                return database;
            }
        };
    }

    private HibernateBundle(List<Class<?>> entityClasses, final DatabaseConfigurationProvider<C> configurationProvider) {
        this.delegate = new NonScanningHibernateBundle<C>(entityClasses, new SessionFactoryFactory()){

            public PooledDataSourceFactory getDataSourceFactory(C configuration) {
                DataSourceFactory database = (DataSourceFactory)configurationProvider.apply(configuration);
                HibernateBundle.this.applyDefaultSettings(database);
                return database;
            }
        };
    }

    private void applyDefaultSettings(DataSourceFactory database) {
        if (database.getDriverClass() == null) {
            database.setDriverClass(POSTGRES_DRIVER_CLASS);
        }
        if (database.getProperties() == null) {
            database.setProperties(new LinkedHashMap());
        }
        DEFAULT_PROPERTIES.entrySet().stream().filter(e -> !database.getProperties().containsKey(e.getKey())).forEach(e -> database.getProperties().put((String)e.getKey(), (String)e.getValue()));
    }

    public static InitialBuilder builder() {
        return new Builder();
    }

    public SessionFactory sessionFactory() {
        return this.delegate.getSessionFactory();
    }

    public void initialize(Bootstrap<?> bootstrap) {
        this.delegate.initialize(bootstrap);
    }

    public void run(C configuration, Environment environment) throws Exception {
        this.delegate.run(configuration, environment);
    }

    public static class Builder<T extends Configuration>
    implements InitialBuilder,
    ScanPackageBuilder<T>,
    FinalBuilder<T> {
        private Set<String> packagesToScan = new LinkedHashSet<String>();
        private DatabaseConfigurationProvider<T> configurationProvider;
        private List<Class<?>> entityClasses;

        private Builder() {
        }

        private Builder(DatabaseConfigurationProvider<T> configurationProvider) {
            this.configurationProvider = configurationProvider;
        }

        public <C extends Configuration> ScanPackageBuilder<C> withConfigurationProvider(DatabaseConfigurationProvider<C> configurationProvider) {
            return new Builder<C>(configurationProvider);
        }

        @Override
        public FinalBuilder<T> withEntityScanPackage(@NotNull String packageToScanForEntities) {
            this.packagesToScan.add((String)Validate.notBlank((CharSequence)packageToScanForEntities));
            return this;
        }

        @Override
        public FinalBuilder<T> withEntityClasses(Class<?> ... entityClasses) {
            Validate.notEmpty((Object[])entityClasses);
            this.entityClasses = Arrays.asList(entityClasses);
            return this;
        }

        @Override
        public FinalBuilder<T> withEntityScanPackageClass(@NotNull Class<?> markerClass) {
            return this.withEntityScanPackage(markerClass.getPackage().getName());
        }

        @Override
        public HibernateBundle<T> build() {
            return this.packagesToScan != null && !this.packagesToScan.isEmpty() ? new HibernateBundle<T>(this.packagesToScan, this.configurationProvider) : new HibernateBundle<T>(this.entityClasses, this.configurationProvider);
        }
    }

    public static interface FinalBuilder<T extends Configuration>
    extends ScanPackageBuilder<T> {
        public HibernateBundle<T> build();
    }

    public static interface ScanPackageBuilder<T extends Configuration> {
        public FinalBuilder<T> withEntityScanPackage(@NotNull String var1);

        public FinalBuilder<T> withEntityScanPackageClass(@NotNull Class<?> var1);

        public FinalBuilder<T> withEntityClasses(Class<?> ... var1);
    }

    public static interface InitialBuilder {
        public <T extends Configuration> ScanPackageBuilder<T> withConfigurationProvider(@NotNull DatabaseConfigurationProvider<T> var1);
    }
}

