/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.hibernate;

import io.dropwizard.db.DataSourceFactory;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigrationService {
    public static final String DEFAULT_COMMAND_NAME = "migrateDB";
    public static final String DEFAULT_COMMAND_DOC = "Migrate DB to the actual schema version.";
    private static final Logger LOG = LoggerFactory.getLogger(DbMigrationService.class);
    private DataSourceFactory database;

    public DbMigrationService(DataSourceFactory database) {
        this.database = database;
    }

    public void migrateDatabase() {
        String databaseUrl = this.database.getUrl();
        String databaseSchema = this.database.getProperties().getOrDefault("currentSchema", "public");
        LOG.info("Starting database migration for schema {} using database {}", (Object)databaseSchema, (Object)databaseUrl);
        FluentConfiguration configuration = new FluentConfiguration().dataSource(databaseUrl, this.database.getUser(), this.database.getPassword()).schemas(new String[]{databaseSchema});
        Flyway flyway = new Flyway((Configuration)configuration);
        flyway.migrate();
        LOG.info("Database migration successful.");
    }
}

