/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.confluent.builder;

import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;
import org.sdase.commons.server.kafka.confluent.serializers.WrappedNoSerializationErrorAvroDeserializer;

public class WrappedAvroDeserializer {
    public static <T> ClassTypeBuilder<T> builder() {
        return new Builder();
    }

    private static class Builder<T>
    implements ClassTypeBuilder<T>,
    ConfigBuilder<T>,
    FinalBuilder<T> {
        private Class<T> clazz;
        private Map<String, String> configMap;

        private Builder() {
        }

        @Override
        public ConfigBuilder<T> withClassType(Class<T> clazz) {
            this.clazz = clazz;
            return this;
        }

        @Override
        public FinalBuilder<T> withConfigProperties(Map<String, String> configMap) {
            this.configMap = configMap;
            return this;
        }

        @Override
        public Deserializer<T> build(boolean isKey) {
            WrappedNoSerializationErrorAvroDeserializer<T> build = new WrappedNoSerializationErrorAvroDeserializer<T>(this.clazz);
            build.configure(this.configMap, isKey);
            return build;
        }
    }

    public static interface FinalBuilder<T> {
        public Deserializer<T> build(boolean var1);
    }

    public static interface ConfigBuilder<T> {
        public FinalBuilder<T> withConfigProperties(Map<String, String> var1);
    }

    public static interface ClassTypeBuilder<T> {
        public ConfigBuilder<T> withClassType(Class<T> var1);
    }
}

