/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.kafka.confluent.serializers;

import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrappedNoSerializationErrorAvroDeserializer<T>
implements Deserializer<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WrappedNoSerializationErrorAvroDeserializer.class);
    private Class<T> clazz;
    private KafkaAvroDeserializer avroDeserializer;

    public WrappedNoSerializationErrorAvroDeserializer(Class<T> clazz) {
        this.clazz = clazz;
        this.avroDeserializer = new KafkaAvroDeserializer();
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.avroDeserializer.configure(configs, isKey);
    }

    public void close() {
        this.avroDeserializer.close();
    }

    public T deserialize(String topic, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        try {
            Object o = this.avroDeserializer.deserialize(topic, data);
            return this.clazz.isInstance(o) ? (T)this.clazz.cast(o) : null;
        }
        catch (SerializationException e) {
            LOGGER.error("Unable to deserialize record for topic {} due to exception", (Object)topic, (Object)e);
            return null;
        }
    }
}

