/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.connection.ServerAddressHelper;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.ImmutableMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.config.store.DistributionDownloadPath;
import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.HttpProxyFactory;
import de.flapdoodle.embed.process.config.store.ImmutableDownloadConfig;
import de.flapdoodle.embed.process.config.store.ProxyFactory;
import de.flapdoodle.embed.process.config.store.SameDownloadPathForEveryDistribution;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.ExtractedArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableExtractedArtifactStore;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbRule
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean enableScripting;
    private final IFeatureAwareVersion version;
    private final long timeoutMs;
    private final String username;
    private final String password;
    private final String database;
    private MongodConfig mongodConfig;
    private MongodExecutable mongodExecutable;
    private volatile boolean started;

    private static MongodStarter ensureMongodStarter() {
        return LazyHolder.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private MongoDbRule(String username, String password, String database, boolean enableScripting, IFeatureAwareVersion version, long timeoutMs) {
        this.version = Objects.requireNonNull(version, "version");
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
        this.database = Objects.requireNonNull(database, "database");
        this.enableScripting = enableScripting;
        this.timeoutMs = timeoutMs;
    }

    public String getHost() {
        return this.mongodConfig.net().getBindIp() + ":" + this.mongodConfig.net().getPort();
    }

    public String getDatabase() {
        return this.database;
    }

    public IFeatureAwareVersion getVersion() {
        return this.version;
    }

    public MongoClient createClient() {
        return new MongoClient(ServerAddressHelper.createServerAddress((String)this.getHost()), MongoCredential.createCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()), MongoClientOptions.builder().build());
    }

    public void clearCollections() {
        try (MongoClient client = this.createClient();){
            MongoDatabase db = client.getDatabase(this.database);
            MongoIterable collectionNames = db.listCollectionNames();
            collectionNames.forEach(n -> db.getCollection(n).deleteMany((Bson)new Document()));
        }
    }

    public void clearDatabase() {
        try (MongoClient client = this.createClient();){
            client.dropDatabase(this.database);
        }
    }

    protected void before() {
        this.startMongo();
    }

    protected void after() {
        this.stopMongo();
    }

    private void startMongo() {
        if (this.started) {
            return;
        }
        try {
            ImmutableMongodConfig.Builder mongodConfigBuilder = MongodConfig.builder().version(this.version).net(new Net(Network.getLocalHost().getHostName(), Network.getFreeServerPort(), false));
            if (!this.enableScripting) {
                mongodConfigBuilder.putArgs("--noscripting", "");
            }
            this.mongodConfig = mongodConfigBuilder.build();
            this.mongodExecutable = (MongodExecutable)MongoDbRule.ensureMongodStarter().prepare((ExecutableProcessConfig)this.mongodConfig);
            this.mongodExecutable.start();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            MongoClientOptions options = MongoClientOptions.builder().addServerListener(new ServerListener(){

                public void serverOpening(ServerOpeningEvent event) {
                    countDownLatch.countDown();
                }

                public void serverClosed(ServerClosedEvent event) {
                }

                public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
                }
            }).build();
            try (MongoClient mongoClient = new MongoClient(this.getHost(), options);){
                if (!countDownLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Timeout, MongoDB not started.");
                }
                this.createDatabaseUser(mongoClient);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.started = true;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopMongo, "shutdown mongo"));
    }

    private void stopMongo() {
        if (this.started && this.mongodExecutable != null) {
            this.mongodExecutable.stop();
            this.started = false;
        }
    }

    private void createDatabaseUser(MongoClient mongoClient) {
        MongoDatabase db = mongoClient.getDatabase(this.database);
        BasicDBObject createUserCommand = new BasicDBObject("createUser", (Object)this.username).append("pwd", (Object)this.password).append("roles", Collections.singletonList(new BasicDBObject("role", (Object)"readWrite").append("db", (Object)this.database)));
        db.runCommand((Bson)createUserCommand);
    }

    public static final class Builder {
        public static final Version.Main DEFAULT_VERSION = Version.Main.V3_6;
        public static final Version.Main WINDOWS_VERSION = Version.Main.V4_0;
        private static final long DEFAULT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
        public static final String DEFAULT_USER = "dbuser";
        public static final String DEFAULT_PASSWORD = "sda123";
        public static final String DEFAULT_DATABASE = "default_db";
        private IFeatureAwareVersion version;
        private Long timeoutInMillis;
        private String username = "dbuser";
        private String password = "sda123";
        private String database = "default_db";
        private boolean scripting = false;

        private Builder() {
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder withVersion(IFeatureAwareVersion version) {
            this.version = version;
            return this;
        }

        public Builder withTimeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder enableScripting() {
            this.scripting = true;
            return this;
        }

        private IFeatureAwareVersion determineMongoDbVersion() {
            if (this.version != null) {
                return this.version;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                LOG.warn("Using MongoDB {} as any version of MongoDB < 4.x may cause issues on a Windows system", (Object)WINDOWS_VERSION);
                return WINDOWS_VERSION;
            }
            return DEFAULT_VERSION;
        }

        public MongoDbRule build() {
            IFeatureAwareVersion mongoDbVersion = this.determineMongoDbVersion();
            long t = this.timeoutInMillis == null || this.timeoutInMillis < 1L ? DEFAULT_TIMEOUT_MS : this.timeoutInMillis;
            return new MongoDbRule(this.username, this.password, this.database, this.scripting, mongoDbVersion, t);
        }
    }

    private static class LazyHolder {
        static final MongodStarter INSTANCE = LazyHolder.getMongoStarter();

        private LazyHolder() {
        }

        private static MongodStarter getMongoStarter() {
            ImmutableExtractedArtifactStore.Builder artifactStoreBuilder = ExtractedArtifactStore.builder().from((ExtractedArtifactStore)Defaults.extractedArtifactStoreFor((Command)Command.MongoD)).downloadConfig(LazyHolder.createDownloadConfig());
            return MongodStarter.getInstance((RuntimeConfig)Defaults.runtimeConfigFor((Command)Command.MongoD).artifactStore((IArtifactStore)artifactStoreBuilder.build()).build());
        }

        private static Optional<ProxyFactory> createProxyFactory() {
            String httpProxy = System.getenv("http_proxy");
            if (httpProxy != null) {
                try {
                    URL url = new URL(httpProxy);
                    if (url.getUserInfo() != null) {
                        LazyHolder.configureAuthentication(url);
                    }
                    return Optional.of(new HttpProxyFactory(url.getHost(), url.getPort()));
                }
                catch (MalformedURLException exception) {
                    LOG.error("http_proxy could not be parsed.");
                }
            }
            return Optional.empty();
        }

        private static void configureAuthentication(final URL url) {
            String userInfo = url.getUserInfo();
            int pos = userInfo.indexOf(58);
            if (pos >= 0) {
                final String username = userInfo.substring(0, pos);
                final String password = userInfo.substring(pos + 1);
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(url.getHost()) && url.getPort() == this.getRequestingPort()) {
                            return new PasswordAuthentication(username, password.toCharArray());
                        }
                        return null;
                    }
                });
                System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
            } else {
                LOG.error("http_proxy user info could not be parsed.");
            }
        }

        private static DownloadConfig createDownloadConfig() {
            ImmutableDownloadConfig.Builder downloadConfigBuilder = Defaults.downloadConfigFor((Command)Command.MongoD).proxyFactory(LazyHolder.createProxyFactory());
            String embeddedMongoDownloadPath = System.getenv("EMBEDDED_MONGO_DOWNLOAD_PATH");
            if (embeddedMongoDownloadPath != null) {
                downloadConfigBuilder.downloadPath((DistributionDownloadPath)new SameDownloadPathForEveryDistribution(embeddedMongoDownloadPath));
            }
            return downloadConfigBuilder.build();
        }
    }
}

