/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.rules.TestRule;
import org.sdase.commons.server.mongo.testing.StartLocalMongoDbRule;
import org.sdase.commons.server.mongo.testing.UseExistingMongoDbRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MongoDbRule
extends TestRule {
    public static final String OVERRIDE_MONGODB_CONNECTION_STRING_ENV_NAME = "TEST_MONGODB_CONNECTION_STRING";

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    default public String getHost() {
        return this.getHosts();
    }

    public String getHosts();

    public String getUsername();

    public String getPassword();

    public String getDatabase();

    public String getOptions();

    @Deprecated
    default public IFeatureAwareVersion getVersion() {
        throw new UnsupportedOperationException();
    }

    public MongoClient createClient();

    default public String getServerVersion() {
        try (MongoClient client = this.createClient();){
            String string = client.getDatabase(this.getDatabase()).runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonString(""))).get((Object)"version").toString();
            return string;
        }
    }

    default public void clearCollections() {
        try (MongoClient client = this.createClient();){
            MongoDatabase db = client.getDatabase(this.getDatabase());
            MongoIterable collectionNames = db.listCollectionNames();
            collectionNames.forEach(n -> db.getCollection(n).deleteMany((Bson)new Document()));
        }
    }

    default public void clearDatabase() {
        try (MongoClient client = this.createClient();){
            client.dropDatabase(this.getDatabase());
        }
    }

    public static final class Builder {
        private static final Logger LOG = LoggerFactory.getLogger(Builder.class);
        public static final Version.Main DEFAULT_VERSION = Version.Main.V3_6;
        public static final Version.Main WINDOWS_VERSION = Version.Main.V4_0;
        private static final long DEFAULT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
        @Deprecated
        public static final String DEFAULT_USER = "dbuser";
        @Deprecated
        public static final String DEFAULT_PASSWORD = "sda123";
        @Deprecated
        public static final String DEFAULT_DATABASE = "default_db";
        private IFeatureAwareVersion version;
        private Long timeoutInMillis;
        private String username = "dbuser";
        private String password = "sda123";
        private String database = "default_db";
        private boolean scripting = false;

        private Builder() {
        }

        public Builder withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder withVersion(IFeatureAwareVersion version) {
            this.version = version;
            return this;
        }

        public Builder withTimeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder enableScripting() {
            this.scripting = true;
            return this;
        }

        private IFeatureAwareVersion determineMongoDbVersion() {
            if (this.version != null) {
                return this.version;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                LOG.warn("Using MongoDB {} as any version of MongoDB < 4.x may cause issues on a Windows system", (Object)WINDOWS_VERSION);
                return WINDOWS_VERSION;
            }
            return DEFAULT_VERSION;
        }

        public MongoDbRule build() {
            String mongoDbUrlOverride = System.getenv(MongoDbRule.OVERRIDE_MONGODB_CONNECTION_STRING_ENV_NAME);
            if (StringUtils.isNotBlank((CharSequence)mongoDbUrlOverride)) {
                return new UseExistingMongoDbRule(mongoDbUrlOverride);
            }
            IFeatureAwareVersion mongoDbVersion = this.determineMongoDbVersion();
            long t = this.timeoutInMillis == null || this.timeoutInMillis < 1L ? DEFAULT_TIMEOUT_MS : this.timeoutInMillis;
            return new StartLocalMongoDbRule(this.username, this.password, this.database, this.scripting, mongoDbVersion, t);
        }
    }
}

