/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;
import org.sdase.commons.server.mongo.testing.MongoDbRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseExistingMongoDbRule
extends ExternalResource
implements MongoDbRule {
    private static final Logger LOG = LoggerFactory.getLogger(UseExistingMongoDbRule.class);
    private final String host;
    private final String database;
    private final String username;
    private final String password;
    private final String options;
    private final MongoClientURI mongoClientUri;

    public UseExistingMongoDbRule(String mongoDbConnectionString) {
        this.mongoClientUri = new MongoClientURI(mongoDbConnectionString);
        this.host = String.join((CharSequence)",", this.mongoClientUri.getHosts());
        this.database = this.mongoClientUri.getDatabase();
        this.options = this.optionsFromMongoUrl(mongoDbConnectionString);
        this.username = this.mongoClientUri.getUsername();
        this.password = this.asStringOrNull(this.mongoClientUri.getPassword());
    }

    @Override
    public String getHosts() {
        return this.host;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getOptions() {
        return this.options;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public MongoClient createClient() {
        return new MongoClient(this.mongoClientUri);
    }

    protected void before() {
        if (LOG.isInfoEnabled()) {
            String withPasswordText = StringUtils.isNotBlank((CharSequence)this.password) ? "using a password" : "without password";
            LOG.info("Testing as '{}' {} in MongoDB '{}' at '{}' with options '{}'", new Object[]{this.username, withPasswordText, this.getDatabase(), this.getHosts(), this.getOptions()});
            LOG.info("MongoDB server used for test has version {}", (Object)this.getServerVersion());
        }
    }

    private String optionsFromMongoUrl(String mongoDbUrlOverride) {
        String[] split = mongoDbUrlOverride.split("\\?");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return "";
    }

    private String asStringOrNull(char[] chars) {
        return chars == null ? null : new String(chars);
    }
}

