/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.sdase.commons.server.mongo.testing.MongoDb;
import org.sdase.commons.server.mongo.testing.StartLocalMongoDbClassExtension;
import org.sdase.commons.server.mongo.testing.UseExistingMongoDbClassExtension;

public interface MongoDbClassExtension
extends MongoDb,
BeforeAllCallback {
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends MongoDb.Builder<MongoDbClassExtension> {
        private Builder() {
            this.username = "dbuser";
            this.password = "sda123";
            this.database = "default_db";
        }

        @Override
        public MongoDbClassExtension build() {
            if (StringUtils.isNotBlank((CharSequence)this.mongoDbUrlOverride)) {
                return new UseExistingMongoDbClassExtension(this.mongoDbUrlOverride);
            }
            return new StartLocalMongoDbClassExtension(this.username, this.password, this.database, this.scripting, this.determineMongoDbVersion(), this.getTimeoutMs());
        }
    }
}

