/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import org.apache.commons.lang3.StringUtils;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseExistingMongoDb {
    private static final Logger LOG = LoggerFactory.getLogger(UseExistingMongoDb.class);
    private final String hosts;
    private final String database;
    private final String username;
    private final String password;
    private final String options;
    private final MongoClientURI mongoClientUri;

    public UseExistingMongoDb(String mongoDbConnectionString) {
        this.mongoClientUri = new MongoClientURI(mongoDbConnectionString);
        this.hosts = String.join((CharSequence)",", this.mongoClientUri.getHosts());
        this.database = this.mongoClientUri.getDatabase();
        this.options = this.optionsFromMongoUrl(mongoDbConnectionString);
        this.username = this.mongoClientUri.getUsername();
        this.password = this.asStringOrNull(this.mongoClientUri.getPassword());
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getOptions() {
        return this.options;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public MongoClient createClient() {
        return new MongoClient(this.mongoClientUri);
    }

    public String getServerVersion() {
        try (MongoClient client = this.createClient();){
            String string = client.getDatabase(this.getDatabase()).runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonString(""))).get((Object)"version").toString();
            return string;
        }
    }

    protected void logConnection() {
        if (LOG.isInfoEnabled()) {
            String withPasswordText = StringUtils.isNotBlank((CharSequence)this.password) ? "using a password" : "without password";
            LOG.info("Testing as '{}' {} in MongoDB '{}' at '{}' with options '{}'", new Object[]{this.username, withPasswordText, this.getDatabase(), this.getHosts(), this.getOptions()});
            LOG.info("MongoDB server used for test has version {}", (Object)this.getServerVersion());
        }
    }

    private String optionsFromMongoUrl(String mongoDbUrlOverride) {
        String[] split = mongoDbUrlOverride.split("\\?");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return "";
    }

    private String asStringOrNull(char[] chars) {
        return chars == null ? null : new String(chars);
    }
}

