/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing.internal;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.process.config.store.DistributionDownloadPath;
import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.HttpProxyFactory;
import de.flapdoodle.embed.process.config.store.ImmutableDownloadConfig;
import de.flapdoodle.embed.process.config.store.ProxyFactory;
import de.flapdoodle.embed.process.config.store.SameDownloadPathForEveryDistribution;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Optional;
import org.sdase.commons.server.dropwizard.bundles.SystemPropertyAndEnvironmentLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadConfigFactoryUtil {
    private static final String PROXY_ENV_NAME = "http_proxy";
    private static final String EMBEDDED_MONGO_DOWNLOAD_PATH_ENV_NAME = "EMBEDDED_MONGO_DOWNLOAD_PATH";
    private static final Logger LOG = LoggerFactory.getLogger(DownloadConfigFactoryUtil.class);

    private DownloadConfigFactoryUtil() {
    }

    public static DownloadConfig createDownloadConfig() {
        ImmutableDownloadConfig.Builder downloadConfigBuilder = Defaults.downloadConfigFor((Command)Command.MongoD).proxyFactory(DownloadConfigFactoryUtil.createProxyFactory());
        String embeddedMongoDownloadPath = new SystemPropertyAndEnvironmentLookup().lookup(EMBEDDED_MONGO_DOWNLOAD_PATH_ENV_NAME);
        if (embeddedMongoDownloadPath != null) {
            downloadConfigBuilder.downloadPath((DistributionDownloadPath)new SameDownloadPathForEveryDistribution(embeddedMongoDownloadPath));
        }
        return downloadConfigBuilder.build();
    }

    private static Optional<ProxyFactory> createProxyFactory() {
        String httpProxy = new SystemPropertyAndEnvironmentLookup().lookup(PROXY_ENV_NAME);
        if (httpProxy != null) {
            try {
                URL url = new URL(httpProxy);
                if (url.getUserInfo() != null) {
                    DownloadConfigFactoryUtil.configureAuthentication(url);
                }
                return Optional.of(new HttpProxyFactory(url.getHost(), url.getPort()));
            }
            catch (MalformedURLException exception) {
                LOG.error("http_proxy could not be parsed.");
            }
        }
        return Optional.empty();
    }

    private static void configureAuthentication(final URL url) {
        String userInfo = url.getUserInfo();
        int pos = userInfo.indexOf(58);
        if (pos >= 0) {
            final String username = userInfo.substring(0, pos);
            final String password = userInfo.substring(pos + 1);
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(url.getHost()) && url.getPort() == this.getRequestingPort()) {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                    return null;
                }
            });
            System.setProperty("jdk.http.auth.tunneling.disabledSchemes", "");
        } else {
            LOG.error("http_proxy user info could not be parsed.");
        }
    }
}

