/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import com.mongodb.internal.connection.ServerAddressHelper;
import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.mongo.config.ImmutableMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfig;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.process.config.ExecutableProcessConfig;
import de.flapdoodle.embed.process.config.RuntimeConfig;
import de.flapdoodle.embed.process.extract.DirectoryAndExecutableNaming;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.runtime.Network;
import de.flapdoodle.embed.process.store.ExtractedArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableExtractedArtifactStore;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.sdase.commons.server.mongo.testing.internal.DownloadConfigFactoryUtil;

public class StartLocalMongoDb {
    private final boolean enableScripting;
    protected final IFeatureAwareVersion version;
    private MongodConfig mongodConfig;
    private MongodExecutable mongodExecutable;
    private volatile boolean started;
    private final long timeoutMs;
    protected final String username;
    protected final String password;
    protected final String database;

    private static MongodStarter ensureMongodStarter() {
        return LazyHolder.INSTANCE;
    }

    protected StartLocalMongoDb(String username, String password, String database, boolean enableScripting, IFeatureAwareVersion version, long timeoutMs) {
        this.version = Objects.requireNonNull(version, "version");
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
        this.database = Objects.requireNonNull(database, "database");
        this.enableScripting = enableScripting;
        this.timeoutMs = timeoutMs;
    }

    protected void startMongo() {
        if (this.started) {
            return;
        }
        try {
            ImmutableMongodConfig.Builder mongodConfigBuilder = MongodConfig.builder().version(this.version).net(new Net(Network.getLocalHost().getHostName(), Network.getFreeServerPort(), false));
            if (!this.enableScripting) {
                mongodConfigBuilder.putArgs("--noscripting", "");
            }
            this.mongodConfig = mongodConfigBuilder.build();
            this.mongodExecutable = (MongodExecutable)StartLocalMongoDb.ensureMongodStarter().prepare((ExecutableProcessConfig)this.mongodConfig);
            this.mongodExecutable.start();
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            MongoClientOptions options = MongoClientOptions.builder().addServerListener(new ServerListener(){

                public void serverOpening(ServerOpeningEvent event) {
                    countDownLatch.countDown();
                }

                public void serverClosed(ServerClosedEvent event) {
                }

                public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
                }
            }).build();
            try (MongoClient mongoClient = new MongoClient(this.getHosts(), options);){
                if (!countDownLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Timeout, MongoDB not started.");
                }
                this.createDatabaseUser(mongoClient);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.started = true;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopMongo, "shutdown mongo"));
    }

    protected void stopMongo() {
        if (this.started && this.mongodExecutable != null) {
            this.mongodExecutable.stop();
            this.started = false;
        }
    }

    public String getHosts() {
        return this.mongodConfig.net().getBindIp() + ":" + this.mongodConfig.net().getPort();
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOptions() {
        return "";
    }

    public String getServerVersion() {
        try (MongoClient client = this.createClient();){
            String string = client.getDatabase(this.getDatabase()).runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonString(""))).get((Object)"version").toString();
            return string;
        }
    }

    public MongoClient createClient() {
        return new MongoClient(ServerAddressHelper.createServerAddress((String)this.getHosts()), MongoCredential.createCredential((String)this.username, (String)this.database, (char[])this.password.toCharArray()), MongoClientOptions.builder().build());
    }

    private void createDatabaseUser(MongoClient mongoClient) {
        MongoDatabase db = mongoClient.getDatabase(this.database);
        BasicDBObject createUserCommand = new BasicDBObject("createUser", (Object)this.username).append("pwd", (Object)this.password).append("roles", Collections.singletonList(new BasicDBObject("role", (Object)"readWrite").append("db", (Object)this.database)));
        db.runCommand((Bson)createUserCommand);
    }

    static class LazyHolder {
        static final MongodStarter INSTANCE = LazyHolder.getMongoStarter();

        private LazyHolder() {
        }

        private static MongodStarter getMongoStarter() {
            IArtifactStore artifactStore = LazyHolder.createArtifactStore(SystemUtils.IS_OS_MAC_OSX);
            return MongodStarter.getInstance((RuntimeConfig)Defaults.runtimeConfigFor((Command)Command.MongoD).artifactStore(artifactStore).build());
        }

        static IArtifactStore createArtifactStore(boolean forMacOs) {
            ImmutableExtractedArtifactStore.Builder artifactStoreBuilder = ExtractedArtifactStore.builder().from((ExtractedArtifactStore)Defaults.extractedArtifactStoreFor((Command)Command.MongoD)).downloadConfig(DownloadConfigFactoryUtil.createDownloadConfig());
            if (forMacOs) {
                artifactStoreBuilder.extraction(DirectoryAndExecutableNaming.of((Directory)new PropertyOrPlatformTempDir(), (prefix, postfix) -> "mongod")).temp(DirectoryAndExecutableNaming.of((Directory)new PropertyOrPlatformTempDir(), (prefix, postfix) -> "mongod"));
            } else {
                artifactStoreBuilder.extraction((DirectoryAndExecutableNaming)DirectoryAndExecutableNaming.builder().directory((Directory)new PropertyOrPlatformTempDir()).executableNaming((TempNaming)new UUIDTempNaming()).build());
            }
            return artifactStoreBuilder.build();
        }
    }
}

