/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.TestRule;
import org.sdase.commons.server.mongo.testing.MongoDb;
import org.sdase.commons.server.mongo.testing.StartLocalMongoDbRule;
import org.sdase.commons.server.mongo.testing.UseExistingMongoDbRule;

public interface MongoDbRule
extends MongoDb,
TestRule {
    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    default public String getHost() {
        return this.getHosts();
    }

    @Deprecated
    default public IFeatureAwareVersion getVersion() {
        throw new UnsupportedOperationException();
    }

    public static final class Builder
    extends MongoDb.Builder<MongoDbRule> {
        @Deprecated
        public static final String DEFAULT_USER = "dbuser";
        @Deprecated
        public static final String DEFAULT_PASSWORD = "sda123";
        @Deprecated
        public static final String DEFAULT_DATABASE = "default_db";

        private Builder() {
            this.username = DEFAULT_USER;
            this.password = DEFAULT_PASSWORD;
            this.database = DEFAULT_DATABASE;
        }

        @Override
        public MongoDbRule build() {
            if (StringUtils.isNotBlank((CharSequence)this.mongoDbUrlOverride)) {
                return new UseExistingMongoDbRule(this.mongoDbUrlOverride);
            }
            return new StartLocalMongoDbRule(this.username, this.password, this.database, this.scripting, this.determineMongoDbVersion(), this.getTimeoutMs());
        }
    }
}

