/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.client.MongoDatabase;
import com.mongodb.event.ServerClosedEvent;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.event.ServerListener;
import com.mongodb.event.ServerOpeningEvent;
import de.flapdoodle.embed.mongo.commands.MongodArguments;
import de.flapdoodle.embed.mongo.config.ImmutableNet;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.packageresolver.Command;
import de.flapdoodle.embed.mongo.packageresolver.PlatformPackageResolver;
import de.flapdoodle.embed.mongo.transitions.ImmutableMongod;
import de.flapdoodle.embed.mongo.transitions.Mongod;
import de.flapdoodle.embed.process.config.store.ImmutablePackage;
import de.flapdoodle.embed.process.config.store.Package;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.distribution.Version;
import de.flapdoodle.os.CommonOS;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.Listener;
import de.flapdoodle.reverse.Transition;
import de.flapdoodle.reverse.transitions.ImmutableStart;
import de.flapdoodle.reverse.transitions.Start;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.sdase.commons.server.dropwizard.bundles.SystemPropertyAndEnvironmentLookup;
import org.sdase.commons.server.mongo.testing.MongoDb;

public class StartLocalMongoDb
implements MongoDb {
    private static final String EMBEDDED_MONGO_DOWNLOAD_PATH_ENV_NAME = "EMBEDDED_MONGO_DOWNLOAD_PATH";
    private final boolean enableScripting;
    protected final IFeatureAwareVersion version;
    private AutoCloseable mongodStopper;
    private volatile boolean started;
    private final long timeoutMs;
    protected final String username;
    protected final String password;
    protected final String database;
    protected ConnectionString mongoConnectionString;

    protected StartLocalMongoDb(String username, String password, String database, boolean enableScripting, IFeatureAwareVersion version, long timeoutMs) {
        this.version = Objects.requireNonNull(version, "version");
        this.username = Objects.requireNonNull(username, "username");
        this.password = Objects.requireNonNull(password, "password");
        this.database = Objects.requireNonNull(database, "database");
        this.enableScripting = enableScripting;
        this.timeoutMs = timeoutMs;
    }

    protected void startMongo() {
        if (this.started) {
            return;
        }
        try {
            InetAddress host = de.flapdoodle.net.Net.getLocalHost();
            int serverPort = de.flapdoodle.net.Net.freeServerPort((InetAddress)host);
            String connectionString = "mongodb://" + this.username + ":" + this.password + "@" + host.getHostName() + ":" + serverPort + "/" + this.database + "?authSource=" + this.database;
            this.mongoConnectionString = new ConnectionString(connectionString);
            ImmutableMongod.Builder mongodBuilder = Mongod.builder().net(StartLocalMongoDb.createNet(host, serverPort)).mongodArguments(this.createMongodArguments());
            this.createPackageOfDistribution((Version)this.version).ifPresent(arg_0 -> ((ImmutableMongod.Builder)mongodBuilder).packageOfDistribution(arg_0));
            ImmutableMongod mongod = mongodBuilder.build();
            this.mongodStopper = mongod.start((Version)this.version, new Listener[0]);
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            MongoClientOptions options = MongoClientOptions.builder().addServerListener(new ServerListener(){

                public void serverOpening(ServerOpeningEvent event) {
                    countDownLatch.countDown();
                }

                public void serverClosed(ServerClosedEvent event) {
                }

                public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
                }
            }).build();
            try (MongoClient mongoClient = new MongoClient((String)this.getMongoConnectionString().getHosts().get(0), options);){
                if (!countDownLatch.await(this.timeoutMs, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Timeout, MongoDB not started.");
                }
                this.createDatabaseUser(mongoClient);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.started = true;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopMongo, "shutdown mongo"));
    }

    private static ImmutableStart<Net> createNet(InetAddress host, int serverPort) {
        return Start.to(Net.class).initializedWith((Object)ImmutableNet.builder().bindIp(host.getHostAddress()).port(serverPort).isIpv6(false).build());
    }

    private ImmutableStart<MongodArguments> createMongodArguments() {
        Map extraArgs = this.enableScripting ? Map.of() : Map.of("--noscripting", "");
        return Start.to(MongodArguments.class).initializedWith((Object)MongodArguments.defaults().withArgs(extraArgs));
    }

    private Optional<Transition<Package>> createPackageOfDistribution(Version version) {
        String embeddedMongoDownloadPath = new SystemPropertyAndEnvironmentLookup().lookup(EMBEDDED_MONGO_DOWNLOAD_PATH_ENV_NAME);
        if (embeddedMongoDownloadPath == null) {
            return Optional.empty();
        }
        ImmutablePackage.Builder downloadPackage = Package.builder().from(new PlatformPackageResolver(Command.MongoD).packageFor(Distribution.of((Version)version, (Platform)Platform.detect((Collection)CommonOS.list()))));
        return Optional.of(Start.to(Package.class).initializedWith((Object)downloadPackage.url(embeddedMongoDownloadPath).build()));
    }

    protected void stopMongo() {
        try {
            if (this.started && this.mongodStopper != null) {
                this.mongodStopper.close();
                this.started = false;
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to stop MongoDB", e);
        }
    }

    @Override
    public String getConnectionString() {
        return this.mongoConnectionString.getConnectionString();
    }

    @Override
    public ConnectionString getMongoConnectionString() {
        return this.mongoConnectionString;
    }

    private void createDatabaseUser(MongoClient mongoClient) {
        MongoDatabase db = mongoClient.getDatabase(this.database);
        BasicDBObject createUserCommand = new BasicDBObject("createUser", (Object)this.username).append("pwd", (Object)this.password).append("roles", Collections.singletonList(new BasicDBObject("role", (Object)"readWrite").append("db", (Object)this.database)));
        db.runCommand((Bson)createUserCommand);
    }
}

