/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.ConnectionString;
import org.sdase.commons.server.mongo.testing.MongoDb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UseExistingMongoDb
implements MongoDb {
    private static final Logger LOG = LoggerFactory.getLogger(UseExistingMongoDb.class);
    private final ConnectionString mongoConnectionString;

    public UseExistingMongoDb(String mongoDbConnectionString) {
        this.mongoConnectionString = new ConnectionString(mongoDbConnectionString);
    }

    @Override
    public String getConnectionString() {
        return this.mongoConnectionString.getConnectionString();
    }

    @Override
    public ConnectionString getMongoConnectionString() {
        return this.mongoConnectionString;
    }

    protected void logConnection() {
        if (LOG.isInfoEnabled()) {
            String withPasswordText = this.mongoConnectionString.getPassword() != null ? "using a password" : "without password";
            LOG.info("Testing as '{}' {} in MongoDB '{}' at '{}' with options '{}'", new Object[]{this.mongoConnectionString.getUsername(), withPasswordText, this.mongoConnectionString.getDatabase(), this.mongoConnectionString.getHosts(), this.optionsFromMongoUrl(this.getConnectionString())});
            LOG.info("MongoDB server used for test has version {}", (Object)this.getServerVersion());
        }
    }

    private String optionsFromMongoUrl(String mongoDbUrlOverride) {
        String[] split = mongoDbUrlOverride.split("\\?");
        if (split.length > 1) {
            return split[split.length - 1];
        }
        return "";
    }
}

