/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.mongo.testing;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClient;
import com.mongodb.client.ListCollectionNamesIterable;
import com.mongodb.client.MongoDatabase;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.SystemUtils;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.sdase.commons.server.dropwizard.bundles.SystemPropertyAndEnvironmentLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface MongoDb {
    public static final String OVERRIDE_MONGODB_CONNECTION_STRING_SYSTEM_PROPERTY_NAME = "TEST_MONGODB_CONNECTION_STRING";

    public String getConnectionString();

    public ConnectionString getMongoConnectionString();

    default public MongoClient createClient() {
        return new MongoClient(this.getMongoConnectionString());
    }

    default public String getServerVersion() {
        try (MongoClient client = this.createClient();){
            String string = client.getDatabase(this.getMongoConnectionString().getDatabase()).runCommand((Bson)new BsonDocument("buildinfo", (BsonValue)new BsonString(""))).get((Object)"version").toString();
            return string;
        }
    }

    default public void clearCollections() {
        try (MongoClient client = this.createClient();){
            MongoDatabase db = client.getDatabase(this.getMongoConnectionString().getDatabase());
            ListCollectionNamesIterable collectionNames = db.listCollectionNames();
            collectionNames.forEach(n -> db.getCollection(n).deleteMany((Bson)new Document()));
        }
    }

    default public void clearDatabase() {
        try (MongoClient client = this.createClient();){
            client.dropDatabase(this.getMongoConnectionString().getDatabase());
        }
    }

    public static abstract class Builder<T extends MongoDb> {
        public static final Version.Main DEFAULT_VERSION;
        public static final Version.Main WINDOWS_VERSION;
        protected static final long DEFAULT_TIMEOUT_MS;
        static final String DEFAULT_USER = "dbuser";
        static final String DEFAULT_PASSWORD = "sda123";
        static final String DEFAULT_DATABASE = "default_db";
        private static final Logger LOG;
        protected String mongoDbUrlOverride = new SystemPropertyAndEnvironmentLookup().lookup("TEST_MONGODB_CONNECTION_STRING");
        protected IFeatureAwareVersion version;
        protected Long timeoutInMillis;
        protected String username;
        protected String password;
        protected String database;
        protected boolean scripting = false;

        public Builder<T> withUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> withDatabase(String database) {
            this.database = database;
            return this;
        }

        public Builder<T> withVersion(IFeatureAwareVersion version) {
            this.version = version;
            return this;
        }

        public Builder<T> withTimeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public Builder<T> enableScripting() {
            this.scripting = true;
            return this;
        }

        protected IFeatureAwareVersion determineMongoDbVersion() {
            if (this.version != null) {
                return this.version;
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                LOG.warn("Using MongoDB {} as any version of MongoDB < 4.x may cause issues on a Windows system", (Object)WINDOWS_VERSION);
                return WINDOWS_VERSION;
            }
            return DEFAULT_VERSION;
        }

        protected long getTimeoutMs() {
            return this.timeoutInMillis == null || this.timeoutInMillis < 1L ? DEFAULT_TIMEOUT_MS : this.timeoutInMillis;
        }

        public abstract T build();

        static {
            WINDOWS_VERSION = DEFAULT_VERSION = Version.Main.V4_4;
            DEFAULT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(1L);
            LOG = LoggerFactory.getLogger(Builder.class);
        }
    }
}

