/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.optional.server.openapi.parameter.embed;

import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.QueryParameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@OpenAPIDefinition
public class EmbedParameterModifier
implements ReaderListener {
    private static final String EMBEDDED_PROPERTY = "_embedded";

    public void beforeScan(OpenApiReader reader, OpenAPI openAPI) {
    }

    public void afterScan(OpenApiReader reader, OpenAPI openAPI) {
        if (openAPI == null || openAPI.getComponents() == null) {
            return;
        }
        Map definitions = openAPI.getComponents().getSchemas();
        if (definitions != null && openAPI.getPaths() != null) {
            openAPI.getPaths().forEach((key, path) -> path.readOperations().forEach(o -> this.updateOperations((Operation)o, definitions)));
        }
    }

    private void updateOperations(Operation operation, Map<String, Schema> definitions) {
        operation.getResponses().forEach((key, response) -> {
            Map<String, Schema> embeddedProperties;
            Parameter embedQueryParameter;
            if (response.getContent() == null || !response.getContent().containsKey((Object)"application/json")) {
                return;
            }
            String responseModelName = this.getResponseModelName((MediaType)response.getContent().get((Object)"application/json"));
            if (responseModelName == null) {
                return;
            }
            Schema<?> schemaDefinition = this.getSchemaDefinition(definitions, responseModelName);
            if (schemaDefinition == null) {
                return;
            }
            if (schemaDefinition.getProperties() != null && !schemaDefinition.getProperties().containsKey(EMBEDDED_PROPERTY)) {
                schemaDefinition = this.getResolvedSchemaDefinition(definitions, schemaDefinition);
            }
            if ((embedQueryParameter = this.getEmbedQueryParameter(embeddedProperties = this.getEmbeddedObjectProperty(schemaDefinition))) == null) {
                return;
            }
            operation.addParametersItem(embedQueryParameter);
        });
    }

    private String getOriginalRef(Schema<?> schema) {
        if (schema.get$ref() != null) {
            return schema.get$ref().replaceAll("^#/components/schemas/(.*)", "$1");
        }
        return null;
    }

    private String getResponseModelName(MediaType responseSchema) {
        return this.getOriginalRef(responseSchema.getSchema());
    }

    private Schema<?> getSchemaDefinition(Map<String, Schema> definitions, String name) {
        return definitions.get(name);
    }

    private Schema<?> getResolvedSchemaDefinition(Map<String, Schema> definitions, Schema<?> definition) {
        List nestedRefs = definition.getProperties().values().stream().filter(es -> es instanceof ArraySchema).map(es -> ((ArraySchema)es).getItems()).filter(Objects::nonNull).map(this::getOriginalRef).collect(Collectors.toList());
        if (nestedRefs.size() == 1) {
            return this.getSchemaDefinition(definitions, (String)nestedRefs.get(0));
        }
        return definition;
    }

    private Map<String, Schema> getEmbeddedObjectProperty(Schema<?> definition) {
        Schema schema;
        List allOf;
        HashMap<String, Schema> allProperties = new HashMap<String, Schema>();
        if (definition instanceof ComposedSchema && (allOf = ((ComposedSchema)definition).getAllOf()) != null) {
            allOf.forEach(s -> allProperties.putAll(this.getEmbeddedObjectProperty((Schema<?>)s)));
        }
        if (definition.getProperties() != null && (schema = (Schema)definition.getProperties().get(EMBEDDED_PROPERTY)) != null) {
            allProperties.putAll(schema.getProperties());
        }
        return allProperties;
    }

    private Parameter getEmbedQueryParameter(Map<String, Schema> properties) {
        if (properties != null && !properties.isEmpty()) {
            List embeddableObjects = properties.keySet().stream().sorted().collect(Collectors.toList());
            return new QueryParameter().schema((Schema)new ArraySchema().items((Schema)new StringSchema()._enum(embeddableObjects))).name("embed").description("Select linked resources that should be resolved and embedded into the response");
        }
        return null;
    }
}

