/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.openapi;

import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.server.AbstractServerFactory;
import io.dropwizard.server.ServerFactory;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.lang3.Validate;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.sdase.commons.optional.server.openapi.parameter.embed.EmbedParameterModifier;
import org.sdase.commons.optional.server.openapi.sort.OpenAPISorter;
import org.sdase.commons.server.dropwizard.lifecycle.ManagedShutdownListener;
import org.sdase.commons.server.openapi.ContextIdOpenApiResource;
import org.sdase.commons.server.openapi.filter.OpenAPISpecFilterSet;
import org.sdase.commons.server.openapi.filter.ServerUrlFilter;
import org.sdase.commons.server.openapi.hal.HalLinkDescriptionModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenApiBundle
implements ConfiguredBundle<Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final AtomicInteger UNIQUE_ID_COUNTER = new AtomicInteger();
    private static final String DROPWIZARD_DEFAULT_ROOT_PATH = "/*";
    private final Set<String> resourcePackages;
    private final OpenAPI existingOpenAPI;

    public static InitialBuilder builder() {
        return new Builder();
    }

    public OpenApiBundle(Set<String> resourcePackages, OpenAPI existingOpenAPI) {
        this.resourcePackages = resourcePackages;
        this.existingOpenAPI = existingOpenAPI;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(Configuration configuration, Environment environment) {
        String instanceId = Integer.toString(UNIQUE_ID_COUNTER.incrementAndGet());
        ServerUrlFilter serverUrlFilter = new ServerUrlFilter();
        environment.jersey().register((Object)serverUrlFilter);
        OpenAPISpecFilterSet.register((OpenAPISpecFilter)serverUrlFilter);
        environment.lifecycle().manage((Managed)ManagedShutdownListener.onShutdown(OpenAPISpecFilterSet::clear));
        SwaggerConfiguration oasConfig = new SwaggerConfiguration().openAPI(this.existingOpenAPI != null ? this.existingOpenAPI : new OpenAPI()).prettyPrint(Boolean.valueOf(true)).resourcePackages(this.resourcePackages).readAllResources(Boolean.valueOf(false)).filterClass(OpenAPISpecFilterSet.class.getName());
        environment.jersey().register((Object)new ContextIdOpenApiResource().contextId("openapi.context.id." + instanceId).openApiConfiguration((OpenAPIConfiguration)oasConfig));
        String basePath = this.determineBasePath(configuration);
        String filterBasePath = basePath.endsWith("/") ? basePath : basePath + "/";
        FilterRegistration.Dynamic filter = environment.servlets().addFilter("CORS OpenAPI", CrossOriginFilter.class);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{filterBasePath + "openapi.yaml", filterBasePath + "openapi.json"});
        filter.setInitParameter("allowedOrigins", "*");
        filter.setInitParameter("allowCredentials", Boolean.TRUE.toString());
        filter.setInitParameter("chainPreflight", Boolean.FALSE.toString());
        LOG.info("Initialized OpenAPI with base path '{}' and resource packages: '{}'", (Object)basePath, this.resourcePackages);
    }

    private String determineBasePath(Configuration configuration) {
        ServerFactory serverFactory = configuration.getServerFactory();
        if (serverFactory instanceof AbstractServerFactory) {
            String basePath = ((AbstractServerFactory)serverFactory).getJerseyRootPath().orElse(DROPWIZARD_DEFAULT_ROOT_PATH);
            return DROPWIZARD_DEFAULT_ROOT_PATH.equals(basePath) ? "/" : basePath.replaceAll("^(.*)/\\*$", "$1");
        }
        return "/api";
    }

    public static final class Builder
    implements InitialBuilder,
    FinalBuilder {
        private final Set<String> resourcePackages = new LinkedHashSet<String>();
        private OpenAPI existingOpenAPI;

        Builder() {
            this.addResourcePackageClass((Class)HalLinkDescriptionModifier.class);
            this.addResourcePackageClass((Class)EmbedParameterModifier.class);
            this.addResourcePackageClass((Class)OpenAPISorter.class);
        }

        @Override
        public Builder addResourcePackage(String resourcePackage) {
            Validate.notBlank((CharSequence)resourcePackage, (String)"resourcePackage", (Object[])new Object[0]);
            this.resourcePackages.add(resourcePackage);
            return this;
        }

        @Override
        public Builder addResourcePackageClass(Class<?> resourcePackageClass) {
            this.resourcePackages.add(this.getResourcePackage(resourcePackageClass));
            return this;
        }

        @Override
        public Builder withExistingOpenAPI(String openApiJsonOrYaml) {
            OpenAPIV3Parser openAPIV3Parser = new OpenAPIV3Parser();
            this.existingOpenAPI = openAPIV3Parser.readContents(openApiJsonOrYaml).getOpenAPI().servers(null);
            return this;
        }

        @Override
        public OpenApiBundle build() {
            return new OpenApiBundle(this.resourcePackages, this.existingOpenAPI);
        }

        private String getResourcePackage(Class<?> resourcePackageClass) {
            return Objects.requireNonNull(resourcePackageClass, "resourcePackageClass").getPackage().getName();
        }
    }

    public static interface FinalBuilder
    extends InitialBuilder {
        public OpenApiBundle build();
    }

    public static interface InitialBuilder {
        public FinalBuilder withExistingOpenAPI(String var1);

        default public FinalBuilder withExistingOpenAPIFromClasspathResource(String path) {
            try (Scanner scanner = new Scanner(this.getClass().getResourceAsStream(path), StandardCharsets.UTF_8.name());){
                FinalBuilder finalBuilder = this.withExistingOpenAPI(scanner.useDelimiter("\\A").next());
                return finalBuilder;
            }
        }

        public FinalBuilder addResourcePackage(String var1);

        public FinalBuilder addResourcePackageClass(Class<?> var1);
    }
}

