/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.openapi.hal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class HALModelResolver
extends ModelResolver {
    private final Map<String, Map<String, HalPropertyConfiguration>> componentHalProperties = new LinkedHashMap<String, Map<String, HalPropertyConfiguration>>();
    private final HashMap<Type, Schema<?>> modelByType = new HashMap();

    public HALModelResolver(ObjectMapper mapper) {
        super(mapper);
    }

    private void discoverHalProperties(AnnotatedType type) {
        if (type.getParent() != null && type.getCtxAnnotations() != null) {
            for (Annotation annotation : type.getCtxAnnotations()) {
                HALReservedProperty.valueOf(annotation.annotationType()).ifPresent(rp -> {
                    this.componentHalProperties.computeIfAbsent(type.getParent().getName(), k -> new LinkedHashMap()).put(type.getPropertyName(), new HalPropertyConfiguration((HALReservedProperty)((Object)rp), rp.getValue(annotation)));
                    this.fixAnnotations(type);
                });
            }
        }
    }

    private void fixAnnotations(AnnotatedType type) {
        if (Arrays.stream(type.getCtxAnnotations()).anyMatch(a -> a instanceof HalModifiedAnnotation)) {
            return;
        }
        Annotation[] annotations = Arrays.copyOf(type.getCtxAnnotations(), type.getCtxAnnotations().length + 1);
        annotations[annotations.length - 1] = new HalModifiedAnnotation(){

            @Override
            public Class<? extends Annotation> annotationType() {
                return this.getClass();
            }
        };
        type.ctxAnnotations(annotations);
    }

    public Schema resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        Type t = type.getType();
        if (t instanceof JavaType) {
            t = ((JavaType)t).getRawClass();
        }
        this.discoverHalProperties(type);
        if (this.modelByType.containsKey(t)) {
            return this.modelByType.get(t);
        }
        Schema model = super.resolve(type, context, chain);
        if (model != null && model.getProperties() != null && this.componentHalProperties.containsKey(model.getName())) {
            this.reorderHalProperties(model);
            this.modelByType.put(t, model);
        }
        return model;
    }

    private void reorderHalProperties(Schema<?> model) {
        LinkedHashMap<String, Schema> properties = new LinkedHashMap<String, Schema>();
        HashSet originalProperties = new HashSet();
        Map<String, HalPropertyConfiguration> halProperties = this.componentHalProperties.get(model.getName());
        for (Map.Entry entry : model.getProperties().entrySet()) {
            if (!halProperties.containsKey(entry.getKey())) continue;
            HalPropertyConfiguration halPropertyConfiguration = halProperties.get(entry.getKey());
            String halType = halPropertyConfiguration.halType.getName();
            String name = halPropertyConfiguration.specificName.isEmpty() ? (String)entry.getKey() : halPropertyConfiguration.specificName;
            properties.computeIfAbsent(halType, s -> new MapSchema()).addProperties(name, (Schema)entry.getValue());
            originalProperties.add(entry.getKey());
        }
        for (Map.Entry entry : properties.entrySet()) {
            model.addProperties((String)entry.getKey(), (Schema)entry.getValue());
        }
        for (String propertyName : originalProperties) {
            model.getProperties().remove(propertyName);
        }
    }

    public static interface HalModifiedAnnotation
    extends Annotation {
    }

    public static enum HALReservedProperty {
        LINKS("_links", Link.class),
        EMBEDDED("_embedded", EmbeddedResource.class);

        private final String name;
        private final Class<? extends Annotation> annotation;
        private final Method valueMethod;

        private HALReservedProperty(String name, Class<? extends Annotation> annotation) {
            this.name = name;
            this.annotation = annotation;
            try {
                this.valueMethod = annotation.getDeclaredMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getValue(Annotation annotation) {
            try {
                return (String)this.valueMethod.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Unable to get default value from annotation", e);
            }
        }

        public static Optional<HALReservedProperty> valueOf(Class<? extends Annotation> annotation) {
            for (HALReservedProperty rp : HALReservedProperty.values()) {
                if (!rp.annotation.equals(annotation)) continue;
                return Optional.of(rp);
            }
            return Optional.empty();
        }
    }

    private static class HalPropertyConfiguration {
        public final HALReservedProperty halType;
        public final String specificName;

        public HalPropertyConfiguration(HALReservedProperty halType, String specificName) {
            this.halType = halType;
            this.specificName = specificName;
        }
    }
}

