/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.optional.server.openapi.sort;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class OpenAPISorter {
    private OpenAPISorter() {
    }

    public static OpenAPI sort(OpenAPI swagger) {
        swagger.setPaths(OpenAPISorter.sortPaths(swagger.getPaths()));
        OpenAPISorter.sortComponents(swagger.getComponents());
        return swagger;
    }

    private static Paths sortPaths(Paths paths) {
        if (paths == null) {
            return null;
        }
        TreeMap sorted = new TreeMap(paths);
        paths.clear();
        paths.putAll(sorted);
        return paths;
    }

    private static void sortComponents(Components components) {
        if (components == null) {
            return;
        }
        components.setSchemas(OpenAPISorter.sortSchemas(components.getSchemas()));
        components.setResponses(OpenAPISorter.createSorted(components.getResponses()));
        components.setParameters(OpenAPISorter.createSorted(components.getParameters()));
        components.setExamples(OpenAPISorter.createSorted(components.getExamples()));
        components.setRequestBodies(OpenAPISorter.createSorted(components.getRequestBodies()));
        components.setHeaders(OpenAPISorter.createSorted(components.getHeaders()));
        components.setSecuritySchemes(OpenAPISorter.createSorted(components.getSecuritySchemes()));
        components.setLinks(OpenAPISorter.createSorted(components.getLinks()));
        components.setCallbacks(OpenAPISorter.createSorted(components.getCallbacks()));
        components.setExtensions(OpenAPISorter.createSorted(components.getExtensions()));
    }

    private static SortedMap<String, Schema> sortSchemas(Map<String, Schema> schemas) {
        if (schemas == null) {
            return null;
        }
        TreeMap<String, Schema> sorted = new TreeMap<String, Schema>();
        schemas.entrySet().forEach(entry -> {
            Schema schema = (Schema)entry.getValue();
            schema.setProperties(OpenAPISorter.sortSchemas(schema.getProperties()));
            sorted.put((String)entry.getKey(), schema);
        });
        return sorted;
    }

    private static <T> SortedMap<String, T> createSorted(Map<String, T> map) {
        return map == null ? null : new TreeMap<String, T>(map);
    }
}

