package org.sdase.commons.server.openapi;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.LinkedHashMap;
import org.sdase.commons.shared.yaml.YamlUtil;

public class OpenApiFileHelper {
  private OpenApiFileHelper() {
    // prevent initialization
  }

  /**
   * Normalize an textual OpenApi in the {@code yaml} format and remove all environment-specific
   * contents.
   *
   * <ul>
   *   <li>Removes the {@code servers} list that is automatically generated by {@link
   *       org.sdase.commons.server.openapi.filter.ServerUrlFilter} but disrupts the repeatability
   *       in tests where the application run on random ports.
   * </ul>
   *
   * @param yaml the content of the {@code openapi.yaml} file
   * @return the cleaned up {@code yaml}
   */
  public static String normalizeOpenApiYaml(String yaml) {
    LinkedHashMap<String, Object> yamlMap =
        YamlUtil.load(yaml, new TypeReference<LinkedHashMap<String, Object>>() {});
    yamlMap.remove("servers");
    return YamlUtil.writeValueAsString(yamlMap);
  }
}
