/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.handlers.RequestHandler2;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import io.dropwizard.Configuration;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.opentracing.Tracer;
import io.opentracing.contrib.aws.TracingRequestHandler;
import io.opentracing.util.GlobalTracer;
import javax.validation.constraints.NotNull;
import org.sdase.commons.server.dropwizard.lifecycle.ManagedShutdownListener;
import org.sdase.commons.server.s3.S3Configuration;
import org.sdase.commons.server.s3.S3ConfigurationProvider;

public class S3Bundle<C extends Configuration>
implements ConfiguredBundle<C> {
    private final S3ConfigurationProvider<C> configurationProvider;
    private final Tracer tracer;
    private AmazonS3 s3Client;

    private S3Bundle(S3ConfigurationProvider<C> configurationProvider, Tracer tracer) {
        this.configurationProvider = configurationProvider;
        this.tracer = tracer;
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(C configuration, Environment environment) throws Exception {
        S3Configuration s3Configuration = (S3Configuration)this.configurationProvider.apply(configuration);
        String region = s3Configuration.getRegion();
        if (region == null || "".equals(region)) {
            region = Regions.DEFAULT_REGION.getName();
        }
        BasicAWSCredentials credentials = new BasicAWSCredentials(s3Configuration.getAccessKey(), s3Configuration.getSecretKey());
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSignerOverride(s3Configuration.getSignerOverride());
        Tracer currentTracer = this.tracer == null ? GlobalTracer.get() : this.tracer;
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRequestHandlers(new RequestHandler2[]{new TracingRequestHandler(currentTracer)})).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Configuration.getEndpoint(), region))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)credentials))).build();
        environment.lifecycle().manage((Managed)ManagedShutdownListener.onShutdown(() -> ((AmazonS3)this.s3Client).shutdown()));
    }

    public AmazonS3 getClient() {
        if (this.s3Client == null) {
            throw new IllegalStateException("S3 client accessed to early, can't be accessed before run.");
        }
        return this.s3Client;
    }

    public static InitialBuilder builder() {
        return new Builder();
    }

    public static class Builder<T extends Configuration>
    implements InitialBuilder,
    FinalBuilder<T> {
        private final S3ConfigurationProvider<T> configProvider;
        private Tracer tracer;

        private Builder() {
            this.configProvider = null;
        }

        private Builder(S3ConfigurationProvider<T> configProvider) {
            this.configProvider = configProvider;
        }

        @Override
        public <C extends Configuration> FinalBuilder<C> withConfigurationProvider(S3ConfigurationProvider<C> configurationProvider) {
            return new Builder<C>(configurationProvider);
        }

        @Override
        public FinalBuilder<T> withTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        @Override
        public S3Bundle<T> build() {
            return new S3Bundle(this.configProvider, this.tracer);
        }
    }

    public static interface FinalBuilder<C extends Configuration> {
        public FinalBuilder<C> withTracer(Tracer var1);

        public S3Bundle<C> build();
    }

    public static interface InitialBuilder {
        public <C extends Configuration> FinalBuilder<C> withConfigurationProvider(@NotNull S3ConfigurationProvider<C> var1);
    }
}

