/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.server.trace.filter;

import java.util.Optional;
import java.util.UUID;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.PreMatching;
import org.sdase.commons.shared.tracing.RequestTracing;
import org.slf4j.MDC;

@PreMatching
public class TraceTokenServerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public void filter(ContainerRequestContext requestContext) {
        if ("OPTIONS".equals(requestContext.getMethod())) {
            return;
        }
        String token = this.extractTokenFromRequest(requestContext).orElse(UUID.randomUUID().toString());
        this.addTokenToRequest(requestContext, token);
        this.addTokenToMdc(token);
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        Optional<String> token = this.extractTokenFromRequestProperties(requestContext);
        token.ifPresent(s -> responseContext.getHeaders().add((Object)"Trace-Token", s));
    }

    private Optional<String> extractTokenFromRequestProperties(ContainerRequestContext requestContext) {
        String requestToken = (String)requestContext.getProperty(RequestTracing.TOKEN_ATTRIBUTE);
        if (requestToken == null || requestToken.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(requestToken);
    }

    private Optional<String> extractTokenFromRequest(ContainerRequestContext requestContext) {
        String requestToken = requestContext.getHeaderString("Trace-Token");
        if (requestToken == null || requestToken.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(requestToken);
    }

    private void addTokenToMdc(String token) {
        if (MDC.getMDCAdapter() != null) {
            MDC.put((String)"Trace-Token", (String)token);
        }
    }

    private void addTokenToRequest(ContainerRequestContext requestContext, String token) {
        requestContext.setProperty(RequestTracing.TOKEN_ATTRIBUTE, (Object)token);
    }
}

