/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.shared.tracing;

import java.io.Closeable;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TraceTokenContext
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(TraceTokenContext.class);
    static final String TRACE_TOKEN_MDC_KEY = "Trace-Token";
    private static final String PARENT_TRACE_TOKEN_MDC_KEY = "Parent-Trace-Token";
    public static final String TRACE_TOKEN_HTTP_HEADER_NAME = "Trace-Token";
    public static final String TRACE_TOKEN_MESSAGING_HEADER_NAME = "Parent-Trace-Token";
    private static final Object CREATE_SEMAPHORE = new Object();
    private final boolean created;
    private final String traceToken;

    private TraceTokenContext(boolean created, String traceToken) {
        this.created = created;
        this.traceToken = traceToken;
    }

    public boolean isCreated() {
        return this.created;
    }

    public boolean isReused() {
        return !this.isCreated();
    }

    public String get() {
        return this.traceToken;
    }

    public void closeIfCreated() {
        if (this.created) {
            TraceTokenContext.closeTraceTokenContext();
        }
    }

    @Override
    public void close() {
        this.closeIfCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceTokenContext getOrCreateTraceTokenContext() {
        Object object = CREATE_SEMAPHORE;
        synchronized (object) {
            if (TraceTokenContext.isTraceTokenContextActive()) {
                return new TraceTokenContext(false, TraceTokenContext.currentTraceToken());
            }
            TraceTokenContext.saveTraceToken(TraceTokenContext.createTraceToken());
            return new TraceTokenContext(true, TraceTokenContext.currentTraceToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceTokenContext continueSynchronousTraceTokenContext(String incomingTraceToken) {
        Object object = CREATE_SEMAPHORE;
        synchronized (object) {
            TraceTokenContext.closeTraceTokenContext();
            if (incomingTraceToken != null && !incomingTraceToken.isBlank()) {
                TraceTokenContext.saveTraceToken(incomingTraceToken);
            } else {
                TraceTokenContext.saveTraceToken(TraceTokenContext.createTraceToken());
            }
            return new TraceTokenContext(true, TraceTokenContext.currentTraceToken());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceTokenContext createFromAsynchronousTraceTokenContext(String incomingParentTraceToken) {
        Object object = CREATE_SEMAPHORE;
        synchronized (object) {
            if (TraceTokenContext.isTraceContextActiveWithParent()) {
                LOG.info("Not adding parent trace token '{}' to existing trace token context with parent.", (Object)incomingParentTraceToken);
                return new TraceTokenContext(false, TraceTokenContext.currentTraceToken());
            }
            if (incomingParentTraceToken != null && !incomingParentTraceToken.isBlank()) {
                MDC.put((String)"Parent-Trace-Token", (String)incomingParentTraceToken);
            }
            if (TraceTokenContext.isTraceTokenContextActive()) {
                return new TraceTokenContext(false, TraceTokenContext.currentTraceToken());
            }
            TraceTokenContext.saveTraceToken(TraceTokenContext.createTraceToken());
            return new TraceTokenContext(true, TraceTokenContext.currentTraceToken());
        }
    }

    public static boolean isTraceTokenContextActive() {
        return TraceTokenContext.currentTraceToken() != null;
    }

    private static boolean isTraceContextActiveWithParent() {
        return TraceTokenContext.currentTraceToken() != null && MDC.get((String)"Parent-Trace-Token") != null;
    }

    private static void closeTraceTokenContext() {
        MDC.remove((String)"Trace-Token");
        MDC.remove((String)"Parent-Trace-Token");
    }

    private static String createTraceToken() {
        return UUID.randomUUID().toString();
    }

    private static String currentTraceToken() {
        return MDC.get((String)"Trace-Token");
    }

    private static void saveTraceToken(String traceToken) {
        MDC.put((String)"Trace-Token", (String)traceToken);
    }
}

