/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.spring.boot.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sdase.commons.spring.boot.asyncapi.AsyncApiGenerator;
import org.sdase.commons.spring.boot.asyncapi.FinalBuilder;
import org.sdase.commons.spring.boot.asyncapi.ReferencedClassNotFoundException;
import org.sdase.commons.spring.boot.asyncapi.jsonschema.JsonSchemaBuilder;
import org.sdase.commons.spring.boot.asyncapi.jsonschema.victools.VictoolsJsonSchemaBuilder;
import org.sdase.commons.spring.boot.asyncapi.util.JsonNodeUtil;
import org.sdase.commons.spring.boot.asyncapi.util.RefUtil;

public class AsyncBuilder
implements AsyncApiGenerator.AsyncApiBaseBuilder,
AsyncApiGenerator.SchemaBuilder,
FinalBuilder {
    private JsonNode asyncApiBaseTemplate;
    private JsonSchemaBuilder jsonSchemaBuilder = VictoolsJsonSchemaBuilder.fromDefaultConfig();

    @Override
    public AsyncApiGenerator.SchemaBuilder withAsyncApiBase(String yamlAsyncApiContent) {
        try {
            this.asyncApiBaseTemplate = ((YAMLMapper)YAMLMapper.builder().build()).readTree(yamlAsyncApiContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error while converting YAML to JSONNode", e);
        }
        return this;
    }

    @Override
    public FinalBuilder withJsonSchemaBuilder(JsonSchemaBuilder jsonSchemaBuilder) {
        this.jsonSchemaBuilder = jsonSchemaBuilder;
        return this;
    }

    @Override
    public JsonNode generate() {
        ObjectNode asyncApiObject = (ObjectNode)this.asyncApiBaseTemplate.deepCopy();
        Map<String, JsonNode> jsonSchemas = this.createSchemasFromReferencedClasses(asyncApiObject);
        this.insertSchemas(jsonSchemas, asyncApiObject);
        JsonNodeUtil.sortJsonNodeInPlace(asyncApiObject.at("/components/schemas"));
        return asyncApiObject;
    }

    private Map<String, JsonNode> createSchemasFromReferencedClasses(ObjectNode asyncApi) {
        Set<Type> types = this.findRequiredSchemas((JsonNode)asyncApi).stream().map(this::toType).collect(Collectors.toSet());
        return this.jsonSchemaBuilder.toJsonSchema(types);
    }

    private Set<String> findRequiredSchemas(JsonNode asyncApiJsonNode) {
        String prefix = "class://";
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        RefUtil.updateAllRefsRecursively(asyncApiJsonNode, ref -> {
            String refText = ref.asText();
            if (refText.startsWith(prefix)) {
                result.add(refText.substring(prefix.length()));
                String simpleClassName = refText.substring(refText.lastIndexOf(".") + 1);
                return "#/components/schemas/%s".formatted(simpleClassName);
            }
            return refText;
        });
        return result;
    }

    private void insertSchemas(Map<String, JsonNode> newSchemas, ObjectNode targetAsyncApiObject) {
        ObjectNode components = this.getOrCreateObject(targetAsyncApiObject, "components");
        ObjectNode targetSchemas = this.getOrCreateObject(components, "schemas");
        newSchemas.forEach((arg_0, arg_1) -> ((ObjectNode)targetSchemas).set(arg_0, arg_1));
    }

    private ObjectNode getOrCreateObject(ObjectNode source, String fieldName) {
        if (source.has(fieldName)) {
            JsonNode jsonNode = source.get(fieldName);
            if (jsonNode instanceof ObjectNode) {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                return objectNode;
            }
            throw new IllegalStateException("'%s' is not an Object node but a %s in %s".formatted(fieldName, jsonNode.getClass().getSimpleName(), source));
        }
        ObjectNode newObjectNode = source.objectNode();
        source.set(fieldName, (JsonNode)newObjectNode);
        return newObjectNode;
    }

    private Type toType(String fullyQualifiedClassName) {
        try {
            return this.getClass().getClassLoader().loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new ReferencedClassNotFoundException(e);
        }
    }
}

