/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.spring.boot.asyncapi.jsonschema.victools;

import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.TypeScope;
import jakarta.validation.constraints.NotBlank;

public class NotBlankModule
implements Module {
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forTypesInGeneral().withStringPatternResolver(this::stringPatternResolver);
        builder.forTypesInGeneral().withStringMinLengthResolver(this::stringMinLengthResolver);
    }

    private Integer stringMinLengthResolver(TypeScope target) {
        if (NotBlankModule.isAnnotatedWithNotBlank(target)) {
            return 1;
        }
        return null;
    }

    private String stringPatternResolver(TypeScope target) {
        if (NotBlankModule.isAnnotatedWithNotBlank(target)) {
            return "^.*\\S+.*$";
        }
        return null;
    }

    private static boolean isAnnotatedWithNotBlank(TypeScope target) {
        FieldScope targetField;
        return target instanceof FieldScope && (targetField = (FieldScope)target).getAnnotationConsideringFieldAndGetter(NotBlank.class) != null;
    }
}

