/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.spring.boot.asyncapi.jsonschema.victools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import io.swagger.v3.oas.annotations.media.Schema;

public class SwaggerExampleModule
implements Module {
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withInstanceAttributeOverride(this::resolveExampleAttribute);
    }

    private void resolveExampleAttribute(ObjectNode collectedMemberAttributes, FieldScope member, SchemaGenerationContext context) {
        if (member.isFakeContainerItemScope()) {
            return;
        }
        Schema schema = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class);
        if (schema == null) {
            return;
        }
        String exampleValue = schema.example();
        if (exampleValue == null || exampleValue.isBlank()) {
            return;
        }
        ArrayNode examples = context.getGeneratorConfig().createArrayNode();
        if (this.isStringType(member, context)) {
            examples.add(exampleValue);
        } else {
            examples.add(this.readExampleAsJson(context, exampleValue));
        }
        collectedMemberAttributes.set("examples", (JsonNode)examples);
    }

    private boolean isStringType(FieldScope member, SchemaGenerationContext context) {
        try {
            return SchemaKeyword.SchemaType.STRING.getSchemaKeywordValue().equals(context.getGeneratorConfig().getCustomDefinition(member.getType(), context, null).getValue().get("type").asText());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private JsonNode readExampleAsJson(SchemaGenerationContext context, String exampleValue) {
        try {
            return (JsonNode)context.getGeneratorConfig().getObjectMapper().readValue(exampleValue, JsonNode.class);
        }
        catch (JsonProcessingException ignored) {
            return new TextNode(exampleValue);
        }
    }
}

