/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.spring.boot.asyncapi.jsonschema.victools;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.Option;
import com.github.victools.jsonschema.generator.OptionPreset;
import com.github.victools.jsonschema.generator.SchemaGenerator;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaVersion;
import com.github.victools.jsonschema.module.jackson.JacksonModule;
import com.github.victools.jsonschema.module.jackson.JacksonOption;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationModule;
import com.github.victools.jsonschema.module.jakarta.validation.JakartaValidationOption;
import com.github.victools.jsonschema.module.swagger2.Swagger2Module;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.sdase.commons.spring.boot.asyncapi.jsonschema.JsonSchemaBuilder;
import org.sdase.commons.spring.boot.asyncapi.jsonschema.victools.NotBlankModule;
import org.sdase.commons.spring.boot.asyncapi.jsonschema.victools.SwaggerExampleModule;
import org.sdase.commons.spring.boot.asyncapi.util.RefUtil;

public class VictoolsJsonSchemaBuilder
implements JsonSchemaBuilder {
    private final SchemaGenerator schemaGenerator;

    public static VictoolsJsonSchemaBuilder fromDefaultConfig() {
        JacksonModule jacksonModule = new JacksonModule(new JacksonOption[]{JacksonOption.RESPECT_JSONPROPERTY_ORDER, JacksonOption.RESPECT_JSONPROPERTY_REQUIRED, JacksonOption.INLINE_TRANSFORMED_SUBTYPES, JacksonOption.FLATTENED_ENUMS_FROM_JSONPROPERTY});
        JakartaValidationModule jakartaValidationModule = new JakartaValidationModule(new JakartaValidationOption[]{JakartaValidationOption.INCLUDE_PATTERN_EXPRESSIONS, JakartaValidationOption.NOT_NULLABLE_FIELD_IS_REQUIRED});
        Swagger2Module swagger2Module = new Swagger2Module();
        SchemaGeneratorConfigBuilder configBuilder = new SchemaGeneratorConfigBuilder(SchemaVersion.DRAFT_7, OptionPreset.PLAIN_JSON).with(Option.DEFINITIONS_FOR_ALL_OBJECTS, new Option[0]).with(Option.DEFINITION_FOR_MAIN_SCHEMA, new Option[0]).with(Option.DEFINITIONS_FOR_MEMBER_SUPERTYPES, new Option[0]).with(Option.ALLOF_CLEANUP_AT_THE_END, new Option[0]).with((Module)jacksonModule).with((Module)jakartaValidationModule).with((Module)swagger2Module).with((Module)new SwaggerExampleModule()).with((Module)new NotBlankModule());
        configBuilder.forTypesInGeneral().withPropertySorter((o1, o2) -> 0);
        SchemaGeneratorConfig config = configBuilder.build();
        return new VictoolsJsonSchemaBuilder(config);
    }

    public VictoolsJsonSchemaBuilder(SchemaGeneratorConfig schemaGeneratorConfig) {
        this.schemaGenerator = new SchemaGenerator(schemaGeneratorConfig);
    }

    @Override
    public Map<String, JsonNode> toJsonSchema(Type type) {
        Map<String, JsonNode> schema = this.toSchemaMap(this.schemaGenerator.generateSchema(type, new Type[0]));
        schema.values().forEach(this::updateRefsInPlace);
        return schema;
    }

    private void updateRefsInPlace(JsonNode jsonSchemaOfType) {
        RefUtil.updateAllRefsRecursively(jsonSchemaOfType, this::convertRefToDefinitionsIntoRefToComponentsSchemas);
    }

    private String convertRefToDefinitionsIntoRefToComponentsSchemas(TextNode refValue) {
        String ref = refValue.asText();
        if (ref.startsWith("#/definitions/")) {
            return "#/components/schemas/" + ref.substring("#/definitions/".length());
        }
        return ref;
    }

    private Map<String, JsonNode> toSchemaMap(ObjectNode jsonNodesFromVictools) {
        JsonNode generatedDefinitions = jsonNodesFromVictools.get("definitions");
        LinkedHashMap<String, JsonNode> definitions = new LinkedHashMap<String, JsonNode>();
        generatedDefinitions.fieldNames().forEachRemaining(name -> definitions.put((String)name, generatedDefinitions.get(name)));
        return definitions;
    }
}

