/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.spring.boot.asyncapi.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.function.Function;

public class RefUtil {
    private static final String REF_KEY = "$ref";

    private RefUtil() {
    }

    public static void updateAllRefsRecursively(JsonNode node, Function<TextNode, String> refRewriter) {
        if (node instanceof ContainerNode) {
            ContainerNode containerNode = (ContainerNode)node;
            RefUtil.mergeAllObjectsWithRefsRecursively((JsonNode)containerNode, textNode -> containerNode.objectNode().put(REF_KEY, (String)refRewriter.apply((TextNode)textNode)));
        }
    }

    public static void mergeAllObjectsWithRefsRecursively(JsonNode node, Function<TextNode, ObjectNode> refRewriter) {
        if (node instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)node;
            ObjectNode iteratorNode = objectNode.deepCopy();
            iteratorNode.fieldNames().forEachRemaining(fieldName -> {
                JsonNode fieldValueNode = objectNode.get(fieldName);
                if (fieldName.equals(REF_KEY) && fieldValueNode instanceof TextNode) {
                    TextNode ref = (TextNode)fieldValueNode;
                    ObjectNode replacementForObjectWithRef = (ObjectNode)refRewriter.apply(ref);
                    if (replacementForObjectWithRef != null) {
                        objectNode.remove(REF_KEY);
                        objectNode.setAll(replacementForObjectWithRef);
                    }
                } else if (fieldValueNode instanceof ArrayNode) {
                    ArrayNode arrayNode = (ArrayNode)fieldValueNode;
                    arrayNode.forEach(item -> RefUtil.mergeAllObjectsWithRefsRecursively(item, refRewriter));
                } else {
                    RefUtil.mergeAllObjectsWithRefsRecursively(fieldValueNode, refRewriter);
                }
            });
        } else if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            arrayNode.forEach(item -> RefUtil.mergeAllObjectsWithRefsRecursively(item, refRewriter));
        }
    }
}

