/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.cacertificates;

import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.sdase.commons.cacertificates.ssl.CertificateReader;
import org.sdase.commons.cacertificates.ssl.SslUtil;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class CaCertificatesConfiguration {
    private final CertificateReader certificateReader;

    public CaCertificatesConfiguration(@Value(value="${sda.caCertificates.certificatesDir:/var/trust/certificates}") String defaultTrustedCertificatesDir) {
        this.certificateReader = new CertificateReader(defaultTrustedCertificatesDir);
    }

    @Bean
    @ConditionalOnMissingBean
    public SSLContext sslContext() {
        String certificatesAsString = this.certificateReader.readCertificates().orElse(null);
        KeyStore keyStoreOrNull = SslUtil.createTruststoreFromPemKey(certificatesAsString);
        return SslUtil.createSslContext(keyStoreOrNull);
    }
}

