/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.cacertificates.ssl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateReader {
    private static final Logger LOG = LoggerFactory.getLogger(CertificateReader.class);
    private static final int MAX_RECURSIVE_DEPTH = 10;
    private final String pathToCertificatesDir;

    public CertificateReader(String pathToCertificatesDir) {
        this.pathToCertificatesDir = pathToCertificatesDir;
    }

    public Optional<String> readCertificates() {
        Optional<Path> optionalPath = this.toPathIfExists(this.pathToCertificatesDir);
        if (optionalPath.isPresent()) {
            LOG.info("Checking for CA certificates in {}", (Object)this.pathToCertificatesDir);
            return this.findAllPemContent(optionalPath.get());
        }
        LOG.info("Not collecting CA certificates, {} does not exist or is not a directory.", (Object)this.pathToCertificatesDir);
        return Optional.empty();
    }

    private Optional<Path> toPathIfExists(String location) {
        Optional<Path> path = Optional.of(Paths.get(location, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0]));
        if (path.isPresent() && !Files.isReadable(path.get())) {
            throw new IllegalStateException(String.format("Existing directory %s is not readable.", location));
        }
        return path;
    }

    private Optional<String> findAllPemContent(Path path) {
        Optional<String> optional;
        block8: {
            Stream<Path> pathStream = Files.walk(path, 10, new FileVisitOption[0]);
            try {
                optional = Optional.of(pathStream.peek(p -> LOG.debug("Checking {}", p)).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::isPemFile).map(this::readContent).collect(Collectors.joining("\n\n"))).filter(s -> !s.isBlank());
                if (pathStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (pathStream != null) {
                        try {
                            pathStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(String.format("Failed to read pem files from %s", path), e);
                }
            }
            pathStream.close();
        }
        return optional;
    }

    private boolean isPemFile(Path filePath) {
        boolean isPemFile = filePath.getFileName().toString().endsWith(".pem");
        if (!isPemFile) {
            LOG.info("Omitting {}: not a .pem file", (Object)filePath);
        }
        return isPemFile;
    }

    private String readContent(Path pemFile) {
        try {
            return Files.readString(pemFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(String.format("Failed to read %s", pemFile), e);
        }
    }
}

