/*
 * Decompiled with CFR 0.152.
 */
package org.sdase.commons.cacertificates.ssl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.X509TrustedCertificateBlock;
import org.sdase.commons.cacertificates.ssl.CompositeX509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.Nullable;

public class SslUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SslUtil.class);
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";

    private SslUtil() {
    }

    public static SSLContext createSslContext(@Nullable KeyStore keystore) {
        try {
            TrustManager[] trustManagers = new TrustManager[]{SslUtil.createCompositeTrustManager(keystore)};
            SSLContext sslContext = SSLContext.getInstance(DEFAULT_SSL_PROTOCOL);
            sslContext.init(null, trustManagers, SslUtil.createSecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static KeyStore createTruststoreFromPemKey(@Nullable String certificateAsString) {
        KeyStore keyStore;
        if (certificateAsString == null) {
            return null;
        }
        PEMParser parser = new PEMParser((Reader)new StringReader(certificateAsString));
        try {
            X509Certificate certificate;
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(null, null);
            int i = 0;
            while ((certificate = SslUtil.parseCert(parser)) != null) {
                keyStore2.setCertificateEntry("cert_" + i, certificate);
                ++i;
            }
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    parser.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        parser.close();
        return keyStore;
    }

    public static X509Certificate parseCert(PEMParser parser) throws IOException, CertificateException {
        Object certificateObject = parser.readObject();
        if (certificateObject == null) {
            return null;
        }
        if (certificateObject instanceof X509CertificateHolder) {
            X509CertificateHolder certHolder = (X509CertificateHolder)certificateObject;
            return new JcaX509CertificateConverter().getCertificate(certHolder);
        }
        if (certificateObject instanceof X509TrustedCertificateBlock) {
            X509TrustedCertificateBlock certHolder = (X509TrustedCertificateBlock)certificateObject;
            return new JcaX509CertificateConverter().getCertificate(certHolder.getCertificateHolder());
        }
        throw new CertificateException("Could not read certificate of type " + certificateObject.getClass());
    }

    public static SecureRandom createSecureRandom() throws NoSuchAlgorithmException {
        String algorithmNativePRNG = "NativePRNG";
        String algorithmWindowsPRNG = "Windows-PRNG";
        try {
            return SecureRandom.getInstance(algorithmNativePRNG);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Failed to create SecureRandom with algorithm {}. Falling back to {}.This should only happen on windows machines.", new Object[]{algorithmNativePRNG, algorithmWindowsPRNG, e});
            return SecureRandom.getInstance(algorithmWindowsPRNG);
        }
    }

    public static X509TrustManager getTrustManager(String algorithm, KeyStore keyStore) {
        try {
            TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
            factory.init(keyStore);
            return Arrays.stream(factory.getTrustManagers()).filter(X509TrustManager.class::isInstance).map(X509TrustManager.class::cast).findFirst().orElse(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static TrustManager createCompositeTrustManager(@Nullable KeyStore keystore) {
        String defaultTrustManagerAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        ArrayList<X509TrustManager> trustManagersList = new ArrayList<X509TrustManager>();
        trustManagersList.add(SslUtil.getTrustManager(defaultTrustManagerAlgorithm, null));
        if (keystore != null) {
            trustManagersList.add(SslUtil.getTrustManager(defaultTrustManagerAlgorithm, keystore));
        }
        return new CompositeX509TrustManager(trustManagersList);
    }
}

