package org.sdmlib.models.classes.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.codegen.Parser;
import org.sdmlib.codegen.SymTabEntry;
import org.sdmlib.models.classes.ClassModel;
import org.sdmlib.models.classes.Feature;
import org.sdmlib.models.modelsets.ObjectSet;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.graph.Association;
import de.uniks.networkparser.graph.AssociationTypes;
import de.uniks.networkparser.graph.Cardinality;
import de.uniks.networkparser.graph.Clazz;
import de.uniks.networkparser.graph.GraphUtil;
import de.uniks.networkparser.graph.Modifier;
import de.uniks.networkparser.graph.util.ClazzSet;
import de.uniks.networkparser.list.SimpleSet;

public class GenAssociation extends Generator<Association>
{
   private int elistPos;

   private void insertCaseInGenericGet(Clazz clazz, Parser parser, Association partnerRole, String rootDir)
   {
      if (GraphUtil.isInterface(clazz))
      {
         return;
      }
      int pos = parser.indexOf(Parser.METHOD + ":getValue(Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic get method. 
         //         System.err.println("Warning: SDMLib codgen for role" + partnerRole.getName() + " in class " + clazz.getFullName() 
         //            + ": \nDid not find method get(String). Should have been generated by the clazz. " 
         //            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic get method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attribute))" +
               "\n      {" +
               "\n         return ((ClassName) target).getPropertyName();" +
               "\n      }" +
               "\n" 
               );

         String partnerRoleNameUpFirst = StrUtil.upFirstChar(partnerRole.getName());
         
         CGUtil.replaceAll(text, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", partnerRoleNameUpFirst,
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
      }
   }

   private void generateToManyRole(Parser myParser, Clazz clazz, Association partnerRole, StringBuilder text)
   {
      String myClassName = model.getClazz().getName(true);
      ClassModel clazzModel = (ClassModel) model.getClazz().getClassModel();
      
      GenClazzEntity partnerClazz = getGenerator((Clazz)partnerRole.getClazz());
      String partnerClassName = partnerRole.getClazz().getName(true);
      
      
      String partnerRoleName = partnerRole.getName();
      String myRoleName = partnerRole.getOther().getName();
      String partnerClassNameSet = partnerClazz.getModelSetClassNameShort();
      
      String partnerRoleUpFirstChar = StrUtil.upFirstChar(partnerRoleName);
      
      int pos = myParser.indexOf(Parser.ATTRIBUTE + ":PROPERTY_" + partnerRole.getName().toUpperCase());

      if (pos < 0)
      {
         text.append
         (  "\n   " +
               "\n   /********************************************************************" +
               "\n    * <pre>" +
               "\n    *              myCard                       partnerCard" +
               "\n    * myClassName ----------------------------------- partnerClassName" +
               "\n    *              myRoleName                   partnerRoleName" +
               "\n    * </pre>" +
               "\n    */" + 
               "\n   " +
               "\n   public static final String PROPERTY_PARTNER_ROLE_NAME = \"partnerRoleName\";" +
               "\n" );
      }
      
      if (GraphUtil.isInterface(clazz) == false)
      {
         pos = myParser.indexOf(Parser.ATTRIBUTE + ":" + partnerRoleName);

         if (pos < 0)
         {
            text.append ("\n   private type partnerRoleName = null;" +
                         "\n   ");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");

      if (pos < 0)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            text.append 
            (     "\n   public type getPartnerRoleName()" +
                  "\n   {" +
                  "\n      if (this.partnerRoleName == null)" +
                  "\n      {" +
                  "\n         return partnerClassNameSet.EMPTY_SET;" +
                  "\n      }" +
                  "\n   " +
                  "\n      return this.partnerRoleName;" +
                  "\n   }" +
                  "\n");
            
            if (clazzModel.hasFeature(Feature.ALBERTsSets, clazz) == false 
            		&& clazzModel.hasFeature(Feature.PatternObject, clazz) == false
            		&& clazzModel.hasFeature(Feature.Serialization, clazz) == false
            		 ) {
            	CGUtil.replaceAll(text, "partnerClassNameSet.EMPTY_SET", "new type()");
            }
         }
         else
         {
            text.append
            (     "\n   public type getPartnerRoleName();" +
                  "\n");
         }
      }
      
      ArrayList<SymTabEntry> symTabEntries = myParser.getSymTabEntriesFor(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");
      
      elistPos = -1;
      
      if (symTabEntries.size() > 0)
      {
         String type = symTabEntries.get(0).getType();
         elistPos = type.indexOf(":EList<");
      }
      
      if (elistPos >= 0)
      {
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Set()");

         if (pos < 0)
         {
            if (GraphUtil.isInterface(clazz) == false)
            {
               text.append 
               (     "  public type getPartnerRoleNameSet()\n" + 
                     "  {\n" + 
                     "     return new type().with(getPartnerRoleName());\n" + 
                     "  }\n" + 
                     "\n");
            }
            else
            {
               text.append
               (     "\n   public type getPartnerRoleNameSet();" +
                     "\n");
            }
         }
      }
      
      
      if (model.getClazz() == model.getOtherClazz())
      {
         // recursive assoc, add getTransitive methods
         
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Transitive()");
         
         if (pos < 0)
         {
            if (GraphUtil.isInterface(clazz) == false)
            {
               text.append(
                  "   public partnerClassNameSet getPartnerRoleNameTransitive()\n" + 
                  "   {\n" + 
                  "      partnerClassNameSet result = new partnerClassNameSet().with(this);\n" + 
                  "      return result.getPartnerRoleNameTransitive();\n" + 
                  "   }\n" + 
                  "\n" 
                  );
            }
            else
            {
               text.append
               (     "\n   public partnerClassNameSet getPartnerRoleNameTransitive();" +
                     "\n");
            }
            getGenerator(clazz).insertImport(partnerClazz.getModelSetClassName());
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":with" + partnerRoleUpFirstChar + "(" + partnerClassName  +  "...)");
      
      if (pos < 0)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            String withMeth = 
                  "\n   public myClassName withPartnerRoleName(partnerClassName... value)" +
                  "\n   {" +
                  "\n      if(value==null){" + 
                  "\n         return this;" +
                  "\n      }" +
                  "\n      for (partnerClassName item : value)" +
                  "\n      {" +
                  "\n         if (item != null)" +
                  "\n         {" +
                  "\n            if (this.partnerRoleName == null)" +
                  "\n            {" +
                  "\n               this.partnerRoleName = initRoleVar;" +
                  "\n            }" +
                  "\n            " +
                  "\n            boolean changed = this.partnerRoleName.add (item);" +
                  "\n" +
                  "\n            if (changed)" +
                  "\n            {" +
                  "\n               item.withMyRoleName(this);" +
                  "\n               PROPERTYCHANGEADD" +
                  "\n            }" +
                  "\n         }" +
                  "\n      }" +
                  "\n      return this;" +
                  "\n   } " +
                  "\n";
            
            if (this.model.getType()==AssociationTypes.EDGE)
            {
               // uni directional no reverse call
               withMeth = CGUtil.replaceAll(withMeth, "\n               item.withMyRoleName(this);", "");
            }
            
            text.append(withMeth);
           
         }
         else
         {
            text.append
            (     "\n   public myClassName withPartnerRoleName(partnerClassName... value);" +
                  "\n");
         }
         
         if (elistPos >= 0)
         {
            CGUtil.replaceAll(text, "initRoleVar", "this.getPartnerRoleName()");
         }
      }
      
      
      pos = myParser.indexOf(Parser.METHOD + ":without" + partnerRoleUpFirstChar + "(" + partnerClassName  +  "...)");
      
      if (pos < 0)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            String withOutMeth = 
                  "\n   public myClassName withoutPartnerRoleName(partnerClassName... value)" +
                  "\n   {" +
                  "\n      for (partnerClassName item : value)" +
                  "\n      {" +
                  "\n         if ((this.partnerRoleName != null) && (item != null))" +
                  "\n         {" +
                  "\n            if (this.partnerRoleName.remove(item))" +
                  "\n            {" +
                  "\n               item.reverseWithoutCall(this);" +
                  "\n               PROPERTYCHANGEREMOVE" +
                  "\n            }" +
                  "\n         }" +
                  "\n      }" +
                  "\n      return this;" +
                  "\n   }" +
                  "\n";
            
            if (this.model.getType()==AssociationTypes.EDGE)
            {
               // uni directional no reverse call
               withOutMeth = CGUtil.replaceAll(withOutMeth, "\n               item.reverseWithoutCall(this);", "");
            }
            
            text.append (withOutMeth);
         }
         else
         {
            text.append
            (     "\n   public myClassName withoutPartnerRoleName(partnerClassName... value);" +
                  "\n");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + "()");
      
      //TODO UEBERPRUEFEN
      // System.out.println(partnerClassName +" ->" +genClazz.getName());
      String realPartnerClassName = partnerClassName;
      SimpleSet<Clazz> kidClasses = partnerRole.getClazz().getKidClazzes(false);
      ClazzSet kidClassesInterfaces =new ClazzSet();
      for(Clazz item : kidClasses){
         if(GraphUtil.isInterface(item)){
            kidClassesInterfaces.add(item);
         }
      }
      if (GraphUtil.isInterface(partnerRole.getClazz()) && kidClassesInterfaces.size() == 1)
      {
         realPartnerClassName = kidClassesInterfaces.first().getName(true);
      }
      
      if (pos < 0 && GraphUtil.isInterface(partnerRole.getClazz()) == false && kidClassesInterfaces.size() != 1)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            text.append 
            (     "\n   public partnerClassName createPartnerRoleName()" +
                  "\n   {" +
                  "\n      partnerClassName value = new realPartnerClassName();" +
                  "\n      withPartnerRoleName(value);" +
                  "\n      return value;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName createPartnerRoleName();" +
                  "\n");
         }
      }
      
      GenClazzEntity generator = getGenerator(model.getClazz());
      
      // if my partnerclass has subclasses generate createPartnerRoleNameSubClassName() methods
      kidClasses = (SimpleSet<Clazz>) partnerRole.getClazz().getKidClazzes(true).without(partnerRole.getClazz());
      
      for (Clazz kid : kidClasses)
      {
         String kidClassName = CGUtil.shortClassName(kid.getName());
         pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + kidClassName + "()");
         
         
         if (pos < 0 && GraphUtil.isInterface(kid) == false)
         {
            if (GraphUtil.isInterface(clazz) == false)
            {
               text.append 
               (     "\n   public KidClassName createPartnerRoleNameSubClassName()" +
                     "\n   {" +
                     "\n      KidClassName value = new KidClassName();" +
                     "\n      withPartnerRoleName(value);" +
                     "\n      return value;" +
                     "\n   } " +
                     "\n");
            }
            else
            {
               text.append
               (     "\n   public KidClassName createPartnerRoleNameSubClassName();" +
                     "\n");
            }
         }
         
         CGUtil.replaceAll(text, 
            "KidClassName", kidClassName, 
            "PartnerRoleNameSubClassName", partnerRoleUpFirstChar + kidClassName
        	);
         
         if(generator!=null)
         {
        	 myParser.insertImport(kid.getName(false));
         }
      }
      
      String reverseWithoutCall = "set" + StrUtil.upFirstChar(model.getName()) + "(null)";
      
      if (model.getCardinality() == Cardinality.MANY)
      {
         reverseWithoutCall = "without" + StrUtil.upFirstChar(model.getName()) + "(this)";
      }
      
      String propertyChangeAdd = "";
      String propertyChangeRemove = "";
      if(clazzModel.hasFeature(Feature.PropertyChangeSupport, model.getClazz())){
     	 propertyChangeAdd = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, null, item);";
     	 propertyChangeRemove = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, item, null);"; 
      }
      
      CGUtil.replaceAll(text, "PROPERTYCHANGEADD", propertyChangeAdd, "PROPERTYCHANGEREMOVE", propertyChangeRemove);

      CGUtil.replaceAll(text, 
         "myCard", model.getCardinality(),
         "partnerCard", partnerRole.getCardinality(),
         "type", partnerClassNameSet, 
         "initRoleVar", "new " + partnerClassNameSet + "()", 
         "myClassName", myClassName,
         "partnerClassName", partnerClassName,
         "realPartnerClassName", realPartnerClassName,
         "myRoleName", myRoleName,
         "MyRoleName", StrUtil.upFirstChar(myRoleName),
         "partnerRoleName", partnerRoleName,
         "PARTNER_ROLE_NAME", partnerRoleName.toUpperCase(),
         "PartnerRoleName", partnerRoleUpFirstChar,
         "reverseWithoutCall(this)", reverseWithoutCall
         );
      if(generator!=null){
    	  myParser.insertImport(getGenerator(partnerRole.getClazz()).getModelSetClassName());
      }
   } 
   
   private void generateToOneRole(Parser myParser, Clazz clazz, Association partnerRole, StringBuilder text)
   {
      String myClassName = model.getClazz().getName(true);
      
      String partnerClassName = partnerRole.getClazz().getName(true);
      
      String partnerRoleName = partnerRole.getName();
      
      String partnerRoleUpFirstChar = StrUtil.upFirstChar(partnerRoleName);
      
      int pos = myParser.indexOf(Parser.ATTRIBUTE + ":PROPERTY_" + partnerRole.getName().toUpperCase());

      if (pos < 0)
      {
         text.append
         (  "\n   " +
               "\n   /********************************************************************" +
               "\n    * <pre>" +
               "\n    *              myCard                       partnerCard" +
               "\n    * myClassName ----------------------------------- partnerClassName" +
               "\n    *              myRoleName                   partnerRoleName" +
               "\n    * </pre>" +
               "\n    */" + 
               "\n   " +
               "\n   public static final String PROPERTY_PARTNER_ROLE_NAME = \"partnerRoleName\";" +
               "\n" );
      }
      
      if (GraphUtil.isInterface(clazz) == false)
      {
         pos = myParser.indexOf(Parser.ATTRIBUTE + ":" + partnerRoleName);

         if (pos < 0)
         {
            text.append ("\n   private partnerClassName partnerRoleName = null;" +
                         "\n");
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "()");

      if (pos < 0)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            text.append 
            (     "\n   public partnerClassName getPartnerRoleName()" +
                  "\n   {" +
                  "\n      return this.partnerRoleName;" +
                  "\n   }" +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName getPartnerRoleName();" +
                  "\n");
         }
      }
      
      
      if (model.getClazz() == model.getOtherClazz())
      {
         // recursive assoc, add getTransitive methods
         
         pos = myParser.indexOf(Parser.METHOD + ":get" + partnerRoleUpFirstChar + "Transitive()");
         
         if (pos < 0)
         {
            if (GraphUtil.isInterface(clazz) == false)
            {
               text.append(
                  "   public partnerClassNameSet getPartnerRoleNameTransitive()\n" + 
                  "   {\n" + 
                  "      partnerClassNameSet result = new partnerClassNameSet().with(this);\n" + 
                  "      return result.getPartnerRoleNameTransitive();\n" + 
                  "   }\n" + 
                  "\n");
            }
            else
            {
               text.append
               (     "\n   public partnerClassName getPartnerRoleNameTransitive();" +
                     "\n");
            }
            getGenerator(clazz).insertImport(CGUtil.helperClassName(partnerRole.getClazz().getName(false) ,"Set"));
         
         }
      }
      
      pos = myParser.indexOf(Parser.METHOD + ":set" + partnerRoleUpFirstChar + "(" + partnerClassName  +  ")");
      
      if (pos < 0)
      {
         if (GraphUtil.isInterface(clazz) == false)
         {
            String setMeth = "\n   public boolean setPartnerRoleName(partnerClassName value)" +
                  "\n   {" +
                  "\n      boolean changed = false;" +
                  "\n      " +
                  "\n      if (this.partnerRoleName != value)" +
                  "\n      {" +
                  "\n         partnerClassName oldValue = this.partnerRoleName;" +
                  "\n         " +
                  "\n         if (this.partnerRoleName != null)" +
                  "\n         {" +
                  "\n            this.partnerRoleName = null;" +
                  "\n            oldValue.withoutMethodCall(this);" +
                  "\n         }" +
                  "\n         " +
                  "\n         this.partnerRoleName = value;" +
                  "\n         " +
                  "\n         if (value != null)" +
                  "\n         {" +
                  "\n            value.withMyRoleName(this);" +
                  "\n         }" +
                  "\n         " +
                  "\n         PROPERTYCHANGEADD" +
                  "\n         changed = true;" +
                  "\n      }" +
                  "\n      " +
                  "\n      return changed;" +
                  "\n   }" +
                  "\n";

            if (this.model.getType()==AssociationTypes.EDGE)
            {
               // uni directional assoc, do not call reverse
               setMeth = CGUtil.replaceAll(setMeth, 
                  "\n         if (this.partnerRoleName != null)" +
                        "\n         {" +
                        "\n            this.partnerRoleName = null;" +
                        "\n            oldValue.withoutMethodCall(this);" +
                        "\n         }", "",
                        "\n         if (value != null)" +
                              "\n         {" +
                              "\n            value.withMyRoleName(this);" +
                              "\n         }", ""
                     );
            }
            text.append(setMeth);
         }
         else
         {
            text.append
            (     "\n   public boolean setPartnerRoleName(partnerClassName value);" +
                  "\n");
         }
      }
      
      
      pos = myParser.indexOf(Parser.METHOD + ":with" + partnerRoleUpFirstChar + "(" + partnerClassName  +  ")");
      
      if (pos < 0)
      {
    	  if (GraphUtil.isInterface(clazz) == false)
         {
            text.append 
            (     "\n   public myClassName withPartnerRoleName(partnerClassName value)" +
                  "\n   {" +
                  "\n      setPartnerRoleName(value);" +
                  "\n      return this;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public myClassName withPartnerRoleName(partnerClassName value);" +
                  "\n");
         }
      }
      

      pos = myParser.indexOf(Parser.METHOD + ":create" + partnerRoleUpFirstChar + "()");
      
      String realPartnerClassName = partnerClassName;
      
      SimpleSet<Clazz> kidClasses = (SimpleSet<Clazz>) partnerRole.getClazz().getKidClazzes(true).without(partnerRole.getClazz());
      ClazzSet kidClassesInterfaces =new ClazzSet();
      for(Clazz item : kidClasses){
    	  if (item.getModifier().has(Modifier.ABSTRACT) || GraphUtil.isInterface(item)) {
            kidClassesInterfaces.add(item);
         }
      }
      if ((partnerRole.getClazz().getModifier().has(Modifier.ABSTRACT) || GraphUtil.isInterface(partnerRole.getClazz())) &&
    		  kidClassesInterfaces.size() == 1)
      {
         realPartnerClassName = kidClassesInterfaces.first().getName(true);
      }
      
      if (pos < 0 && ! (GraphUtil.isWithNoObjects(partnerRole.getClazz()) && kidClassesInterfaces.size() != 1))
      {
         if (!GraphUtil.isWithNoObjects(clazz))
         {
            text.append 
            (     "\n   public partnerClassName createPartnerRoleName()" +
                  "\n   {" +
                  "\n      partnerClassName value = new realPartnerClassName();" +
                  "\n      withPartnerRoleName(value);" +
                  "\n      return value;" +
                  "\n   } " +
                  "\n");
         }
         else
         {
            text.append
            (     "\n   public partnerClassName createPartnerRoleName();" +
                  "\n");
         }
      }
      
      

      String reverseWithoutCall = "set" + StrUtil.upFirstChar(model.getName()) + "(null)";
      
      if (model.getCardinality() == Cardinality.MANY)
      {
         reverseWithoutCall = "without" + StrUtil.upFirstChar(model.getName()) + "(this)";
      }
      
      String propertyChangeAdd = "";
      if(((ClassModel) model.getClazz().getClassModel()).hasFeature(Feature.PropertyChangeSupport)){
     	 propertyChangeAdd = "getPropertyChangeSupport().firePropertyChange(PROPERTY_PARTNER_ROLE_NAME, oldValue, value);";
      }
      CGUtil.replaceAll(text, "PROPERTYCHANGEADD", propertyChangeAdd);
      CGUtil.replaceAll(text, 
         "myCard", model.getCardinality(),
         "partnerCard", partnerRole.getCardinality(),
         "myClassName", myClassName,
         "partnerClassName", partnerClassName,
         "realPartnerClassName", realPartnerClassName,
         "myRoleName", model.getName(),
         "MyRoleName", StrUtil.upFirstChar(model.getName()),
         "partnerRoleName", partnerRoleName,
         
         "PARTNER_ROLE_NAME", partnerRoleName.toUpperCase(),
         "PartnerRoleName", partnerRoleUpFirstChar,
         "withoutMethodCall(this)", reverseWithoutCall
         );
      
      GenClazzEntity generator = getGenerator(model.getClazz());
      if (model.getOther().getCardinality() == Cardinality.MANY){
         if(generator!=null ){
        	 myParser.insertImport(getGenerator(partnerRole.getClazz()).getModelSetClassName());
         }
      }
   } 
   public void generate(String rootDir, String helperDir, Association partnerRole)
   {
      generate(model.getClazz(), rootDir, helperDir, partnerRole, false);
   }
   
   
   public void generate(Clazz clazz, String rootDir, String helperDir, Association partnerRole, boolean fromSuperClass)
   {
      if (clazz.isExternal())
      {
         return;
      }
      
      Parser myParser = getGenerator(clazz).getOrCreateParser(rootDir);
      
      if ( ! fromSuperClass)
      {
            // add attribute declaration in class file
            StringBuilder text = new StringBuilder();

            if (partnerRole.getCardinality() == Cardinality.MANY) {
               generateToManyRole(myParser, clazz, partnerRole, text);
//               getGenerator(clazz).insertImport(LinkedHashSet.class.getName());
            }
            else
            {
               generateToOneRole(myParser, clazz, partnerRole, text);
            }

            int pos = myParser.indexOf(Parser.CLASS_END);
            try{
            	myParser.insert(pos, text.toString());
            }catch(Exception e){
            	System.out.println("FILE: "+myParser.getFileName());
            	System.out.println("FILEBODY: " +myParser.getFileBody());
            	throw e;
            }

//         if (StrUtil.stringEquals(partnerRole.getCard(), Cardinality.MANY.toString()))
//         {
//            generateEmptySetInPartnerClass(rootDir, partnerRole);
//         }
      }
      
      //import partner role class if package name has changed
      if(!StrUtil.stringEquals(clazz.getName(true), partnerRole.getClazz().getName(true))){
         getGenerator(clazz).insertImport(partnerRole.getClazz().getName(false));
      }
      
      if(!((ClassModel) clazz.getClassModel()).hasFeature(Feature.Serialization)) {
    	  insertRemovalInRemoveYou(clazz, myParser, partnerRole);
    	  getGenerator(clazz).printFile();
    	  return;
      }
      
      Parser creatorParser = getGenerator(clazz).getOrCreateParserForCreatorClass(helperDir);
      
      insertCaseInGenericGet(clazz, creatorParser, partnerRole, rootDir);

      if (partnerRole.getCardinality() == Cardinality.MANY) {
         insertCaseInGenericSetToMany(clazz, creatorParser, partnerRole, rootDir);
      }
      else
      {
         insertCaseInGenericSetToOne(clazz, creatorParser, partnerRole, rootDir);
      }
      
      insertRemovalInRemoveYou(clazz, myParser, partnerRole);
      
      getGenerator(clazz).printFile();
      
      
      // generate property in creator class
      ClassModel classModel = (ClassModel) partnerRole.getClazz().getClassModel();
      if (GraphUtil.isInterface(clazz) == false && classModel.hasFeature(Feature.Serialization, partnerRole.getClazz()))
      {
         insertPropertyInCreatorClass(clazz, creatorParser, partnerRole);

         getGenerator(clazz).printFile(creatorParser);
      }
      
    		  
      if (classModel.hasFeature(Feature.Serialization, partnerRole.getClazz())) {
	      // generate property in model set class
	      Parser modelSetParser = getGenerator(clazz).getOrCreateParserForModelSetFile(helperDir);
	      
		  insertGetterInModelSetFile(clazz, modelSetParser, myParser, partnerRole);
		  insertSetterInModelSetFile(clazz, modelSetParser, partnerRole);
	      
	      getGenerator(clazz).printFile(modelSetParser);
	
	      if(((ClassModel) getModel().getClazz().getClassModel()).hasFeature(Feature.PatternObject)){
	      // generate property in pattern object class
	      Parser patternObjectParser = getGenerator(clazz).getOrCreateParserForPatternObjectFile(helperDir);
	      
	      insertGetterInPatternObjectFile(clazz, patternObjectParser, partnerRole);
	      
	      getGenerator(clazz).printFile(patternObjectParser);
	      }
      }
   }
   
   private void insertRemovalInRemoveYou(Clazz clazz, Parser parser, Association partnerRole)
   {
      if (GraphUtil.isInterface(clazz))
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":removeYou()");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         //         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
         //            + ": \nDid not find method removeYou(). Should have been generated by my clazz. " 
         //            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      String removeCall = "set" + StrUtil.upFirstChar(partnerRole.getName());
      String fullRemoveCall = removeCall + "(null);\n      ";
      if (partnerRole.getCardinality() == Cardinality.MANY) {
         String name = StrUtil.upFirstChar(partnerRole.getName());
         String clazzName = StrUtil.upFirstChar(partnerRole.getClazz().getName());
         clazzName = CGUtil.shortClassName(clazzName);
         removeCall = "without"+name;
         fullRemoveCall = removeCall + "(this.get"+name+"().toArray(new "+clazzName+"[this.get"+name+"().size()]));\n      ";
      }            
      
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":" + removeCall, methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add remove call
         pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":getPropertyChangeSupport", methodBodyStartPos);
         
         if (pos < 0)
         {
            System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getName(false) 
               + ": \nDid not find getPropertyChangeSupport call in method removeYou(). Should have been generated by my clazz. " 
               + "\nCould not add required code fragment there. :( ");

            return;
         }
         
         parser.insert(pos, fullRemoveCall);
      }
   }

   private void insertGetterInModelSetFile(Clazz tgtClass, Parser parser, Parser modelClassParser, Association partnerRole)
   {
      String key = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      StringBuilder text = new StringBuilder();
      
      if (pos < 0)
      {
         text.append(
                  "   /**\n" +
                  "    * Loop through the current set of ContentType objects and collect a set of the ModelType objects reached via thename. \n" +
                  "    * \n" +
                  "    * @return Set of ModelType objects reachable via thename\n" +
                  "    */\n" + 
                  "   public ModelSetType getName()\n" +
                  "   {\n" + 
                  "      ModelSetType result = new ModelSetType();\n" + 
                  "      \n" + 
                  "      for (ContentType obj : this)\n" + 
                  "      {\n" + 
                  "         result.with(obj.getName());\n" + 
                  "      }\n" + 
                  "      \n" + 
                  "      return result;\n" + 
                  "   }\n" + 
                  "\n" + 
                  "   /**\n" +
                  "    * Loop through the current set of ContentType objects and collect all contained objects with "
                        + "reference thename pointing to the object passed as parameter. \n" +
                  "    * \n" +
                  "    * @param value The object required as thename neighbor of the collected results. \n" +
                  "    * \n" +
                  "    * @return Set of ModelType objects referring to value via thename\n" +
                  "    */\n" + 
                  "   public ContentTypeSet filterName(Object value)\n" + 
                  "   {\n" + 
                  "      ObjectSet neighbors = new ObjectSet();\n" + 
                  "\n" + 
                  "      if (value instanceof Collection)\n" + 
                  "      {\n" + 
                  "         neighbors.addAll((Collection<?>) value);\n" + 
                  "      }\n" + 
                  "      else\n" + 
                  "      {\n" + 
                  "         neighbors.add(value);\n" + 
                  "      }\n" + 
                  "      \n" + 
                  "      ContentTypeSet answer = new ContentTypeSet();\n" + 
                  "      \n" + 
                  "      for (ContentType obj : this)\n" + 
                  "      {\n" + 
                  "         if (containsClause)\n" + 
                  "         {\n" + 
                  "            answer.add(obj);\n" + 
                  "         }\n" + 
                  "      }\n" + 
                  "      \n" + 
                  "      return answer;\n" + 
                  "   }\n" + 
                  "\n");
            parser.insertImport(Collection.class.getName());
            parser.insertImport(ObjectSet.class.getName());
            
            String containsClause = "neighbors.contains(obj.get"
                  + StrUtil.upFirstChar(partnerRole.getName()) + "())"
                  + " || (neighbors.isEmpty() && obj.get"
                  + StrUtil.upFirstChar(partnerRole.getName())
                  + "() == null)";
            
            if (partnerRole.getCardinality() == Cardinality.MANY) {
               containsClause = " ! Collections.disjoint(neighbors, obj.get" 
                     + StrUtil.upFirstChar(partnerRole.getName()) + "())";
               parser.insertImport(Collections.class.getName());
            }
            CGUtil.replaceAll(text, "containsClause", containsClause);
            
      }
       
      
      String key2 = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "Transitive()";
      int pos2 = parser.indexOf(key2);
      
      if (pos2 < 0)
      {
         if (model.getClazz() == model.getOtherClazz())
         {
            text
            .append("   /**\n" +
                    "    * Follow thename reference zero or more times and collect all reachable objects. Detect cycles and deal with them. \n" +
                    "    * \n" +
                    "    * @return Set of ModelType objects reachable via thename transitively (including the start set)\n" +
                    "    */\n" 
                  + "   public ModelSetType getNameTransitive()\n"
                  + "   {\n"
                  + "      ModelSetType todo = new ModelSetType().with(this);\n"
                  + "      \n"
                  + "      ModelSetType result = new ModelSetType();\n"
                  + "      \n" + "      while ( ! todo.isEmpty())\n"
                  + "      {\n"
                  + "         ModelType current = todo.first();\n"
                  + "         \n" + "         todo.remove(current);\n"
                  + "         \n"
                  + "         if ( ! result.contains(current))\n"
                  + "         {\n" + "            result.add(current);\n"
                  + "            \n"
                  + "            todo.with(current.getPartnerrolenameupfirst()).minus(result);\n"
                  + "         }\n" + "      }\n" + "      \n"
                  + "      return result;\n" + "   }\n" + "\n" + "");

            if (partnerRole.getCardinality() == Cardinality.ONE) {
               CGUtil.replaceAll(text, 
                  "todo.with(current.getPartnerrolenameupfirst()).minus(result);", 
                  "if ( ! result.contains(current.getName()))\n"
                  + "            {\n"
                  + "               todo.with(current.getName());\n"
                  + "            }");
            }
            getGenerator(model.getClazz()).insertImport(CGUtil.helperClassName(partnerRole.getClazz().getName(false) ,"Set"));
         }
      }
      
      if (pos < 0 || pos2 < 0)
      {      
         String partnerRoleNameUpFirst = StrUtil.upFirstChar(partnerRole.getName());
         String partnerGetterName = partnerRoleNameUpFirst;
         
         modelClassParser.indexOf(key);
         ArrayList<SymTabEntry> symTabEntries = modelClassParser.getSymTabEntriesFor(Parser.METHOD + ":get" + partnerRoleNameUpFirst + "()");
         
         elistPos = -1;
         
         if (symTabEntries.size() > 0)
         {
            String type = symTabEntries.get(0).getType();
            elistPos = type.indexOf(":EList<");
         }
         
         if (elistPos >= 0)
         {
            partnerGetterName += "Set";
         }
         
         CGUtil.replaceAll(text, 
            "ContentType", tgtClass.getName(true),
            "ModelType", partnerRole.getClazz().getName(true),
            "ModelSetType", partnerRole.getClazz().getName(true) + "Set",
            "Name", partnerRoleNameUpFirst,
            "thename", partnerRole.getName(),
            "Partnerrolenameupfirst", partnerGetterName
            );

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         
         if (! partnerRole.getClazz().isExternal())
         {
            // external classes get a set in this util package, no need for an import
            // thus just for real classes that may be in other packages
            String helperClassName = CGUtil.helperClassName(partnerRole.getClazz().getName(false),"Set");
            
            parser.insertImport(helperClassName);
         }
      }
   }


   private void insertGetterInPatternObjectFile(Clazz clazz, Parser parser, Association partnerRole)
   {
      insertFilterNoParamInPatternObjectFile(clazz, parser, partnerRole);
      insertCreateNoParamInPatternObjectFile(clazz, parser, partnerRole);
      insertFilterWithParamInPatternObjectFile(clazz, parser, partnerRole);
      insertCreateWithParamInPatternObjectFile(clazz, parser, partnerRole);
      insertGetInPatternObjectFile(clazz, parser, partnerRole);
   }

   private void insertGetInPatternObjectFile(Clazz clazz, Parser parser, Association partnerRole)
   {
      String key = Parser.METHOD + ":get" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder();
         
         if (elistPos < 0 || partnerRole.getCardinality() == Cardinality.ONE) {
            text.append
            (       "   public TargetType getRoleName()\n"
                  + "   {\n"
                  + "      if (this.getPattern().getHasMatch())\n"
                  + "      {\n"
                  + "         return ((ModelClass) this.getCurrentMatch()).getRoleName();\n"
                  + "      }\n" + "      return null;\n" + "   }\n\n");
         }
         else
         {
            text.append
            (       "   public TargetType getRoleName()\n"
                  + "   {\n"
                  + "      if (this.getPattern().getHasMatch())\n"
                  + "      {\n"
                  + "         return ((ModelClass) this.getCurrentMatch()).getRoleNameSet();\n"
                  + "      }\n" + "      return null;\n" + "   }\n\n");
         }
         
         
//         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         String targetType;
         
         if (partnerRole.getCardinality() == Cardinality.MANY) {
            String fullTargetType = CGUtil.helperClassName(partnerRole.getClazz().getName(false), "Set");
            if (partnerRole.getClazz().isExternal())
            {
               targetType = CGUtil.shortClassName(partnerRole.getClazz().getName()) + "Set";
            }
            else
            {
               targetType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullTargetType, parser);
            }
         }else{
            targetType = getGenerator(partnerRole.getClazz()).shortNameAndImport(partnerRole.getClazz().getName(false), parser);
         }
         
         CGUtil.replaceAll(text, 
            "TargetType", targetType,
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getName(false), parser),
            "RoleName", StrUtil.upFirstChar(partnerRole.getName()), 
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertFilterNoParamInPatternObjectFile(Clazz clazz, Parser parser,
         Association partnerRole)
   {
      String key = Parser.METHOD + ":filter" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public PatternObjectType filterName()\n" + 
            "   {\n" + 
            "      PatternObjectType result = new PatternObjectType(new ClassObjectType[]{});\n" + 
            "      \n" + 
            "      result.setModifier(this.getPattern().getModifier());\n" + 
            "      super.hasLink(ModelClass.PROPERTY_NAME, result);\n" + 
            "      \n" + 
            "      return result;\n" + 
            "   }\n\n");

         //         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getName(false), "PO");
         String patternObjectType = CGUtil.shortClassName(partnerRole.getClazz()+"PO");
         if ( ! partnerRole.getClazz().isExternal())
         {
            patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
         }
         String partnerClass = partnerRole.getClazz().getName();
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "filterName", "filter" + StrUtil.upFirstChar(partnerRole.getName()), 
            "ClassObjectType", partnerClass,
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getName(false), parser),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         if(partnerClass.indexOf(".")<0){
        	 parser.insertImport(partnerRole.getClazz().getName(false));
         }
      }
   }


   private void insertCreateNoParamInPatternObjectFile(Clazz clazz, Parser parser,
         Association partnerRole)
   {
      String key = Parser.METHOD + ":create" + StrUtil.upFirstChar(partnerRole.getName()) + "()";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public PatternObjectType createName()\n" + 
            "   {\n" + 
            "      return this.startCreate().filterName().endCreate();\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, PatternLink.class.getName());
         
         String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getName(false), "PO");
         String patternObjectType = CGUtil.shortClassName(partnerRole.getClazz()+"PO");
         if ( ! partnerRole.getClazz().isExternal())
         {
            patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
         }
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "Name", StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getName(false), parser));

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertFilterWithParamInPatternObjectFile(Clazz clazz, Parser parser,
         Association partnerRole)
   {
      String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getName(false), "PO");
//      String patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
      String patternObjectType = CGUtil.shortClassName(fullPatternObjectType);
      
      String key = Parser.METHOD + ":filter" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + patternObjectType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public ModelPOType filterName(PatternObjectType tgt)\n" + 
            "   {\n" + 
            "      return hasLinkConstraint(tgt, ModelClass.PROPERTY_NAME);\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, LinkConstraint.class.getName());
         
         String fullModelPOType = CGUtil.helperClassName(clazz.getName(false), "PO");
         String modelPOType = getGenerator(clazz).shortNameAndImport(fullModelPOType, parser);
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "filterName", "filter" + StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelClass", getGenerator(model.getClazz()).shortNameAndImport(model.getClazz().getName(false), parser),
            "ModelPOType", modelPOType, 
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase());

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertCreateWithParamInPatternObjectFile(Clazz clazz, Parser parser,
         Association partnerRole)
   {
	   String patternObjectType = partnerRole.getClazz().getName(true)+"PO";
//      String fullPatternObjectType = CGUtil.helperClassName(partnerRole.getClazz().getName(false), "PO");
//      String patternObjectType = getGenerator(partnerRole.getClazz()).shortNameAndImport(fullPatternObjectType, parser);
//      String patternObjectType = CGUtil.shortClassName(fullPatternObjectType);
      
      String key = Parser.METHOD + ":create" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + patternObjectType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   public ModelPOType createName(PatternObjectType tgt)\n" + 
            "   {\n" + 
            "      return this.startCreate().filterName(tgt).endCreate();\n" + 
            "   }\n\n");

//         getGenerator(clazz).insertImport(parser, LinkConstraint.class.getName());
         
         String fullModelPOType = CGUtil.helperClassName(clazz.getName(false), "PO");
         String modelPOType = getGenerator(clazz).shortNameAndImport(fullModelPOType, parser);
         
         CGUtil.replaceAll(text, 
            "PatternObjectType", patternObjectType,
            "Name", StrUtil.upFirstChar(partnerRole.getName()), 
            "ModelPOType", modelPOType);

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
      }
   }


   private void insertSetterInModelSetFile(Clazz tgtClass, Parser parser, Association partnerRole)
   {
      String targetType = partnerRole.getClazz().getName(true);
      
      String key = Parser.METHOD + ":with" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + targetType + ")";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         StringBuilder text = new StringBuilder(
            "   /**\n" +
            "    * Loop through current set of ModelType objects and attach the ContentType object passed as parameter to the Name attribute of each of it. \n" +
            "    * \n" +
            "    * @return The original set of ModelType objects now with the new neighbor attached to their Name attributes.\n" +
            "    */\n" + 
            "   public ModelSetType withName(TargetType value)\n" + 
            "   {\n" + 
            "      for (ContentType obj : this)\n" + 
            "      {\n" + 
            "         obj.withName(value);\n" + 
            "      }\n" + 
            "      \n" + 
            "      return this;\n" + 
            "   }\n\n"
            );

         CGUtil.replaceAll(text, 
            "TargetType", targetType,
            "ContentType", CGUtil.shortClassName(tgtClass.getName(false)),
            "ModelSetType", CGUtil.shortClassName(tgtClass.getName(false)) + "Set",
            "Name", StrUtil.upFirstChar(partnerRole.getName())
            );

         int classEnd = parser.indexOf(Parser.CLASS_END);
         
         parser.insert(classEnd, text.toString());
         
         parser.insertImport(partnerRole.getClazz().getName(false));
      }
      
      if (partnerRole.getCardinality() == Cardinality.MANY) {
         key = Parser.METHOD + ":without" + StrUtil.upFirstChar(partnerRole.getName()) + "(" + targetType + ")";
         pos = parser.indexOf(key);

         if (pos < 0)
         {
            StringBuilder text = new StringBuilder(
               "   /**\n" +
               "    * Loop through current set of ModelType objects and remove the ContentType object passed as parameter from the Name attribute of each of it. \n" +
               "    * \n" +
               "    * @return The original set of ModelType objects now without the old neighbor.\n" +
               "    */\n" + 
               "   public ModelSetType withoutName(TargetType value)\n" + 
               "   {\n" + 
               "      for (ContentType obj : this)\n" + 
               "      {\n" + 
               "         obj.withoutName(value);\n" + 
               "      }\n" + 
               "      \n" + 
               "      return this;\n" + 
               "   }\n\n"
               );

            CGUtil.replaceAll(text, 
               "TargetType", targetType,
               "ContentType", CGUtil.shortClassName(tgtClass.getName(false)),
               "ModelSetType", CGUtil.shortClassName(tgtClass.getName(false)) + "Set",
               "Name", StrUtil.upFirstChar(partnerRole.getName())
               );

            int classEnd = parser.indexOf(Parser.CLASS_END);
            
            parser.insert(classEnd, text.toString());
            
            parser.insertImport(partnerRole.getClazz().getName(false));
         }
      }
   }


   private void insertPropertyInCreatorClass(Clazz clazz, Parser parser, Association partnerRole)
   {
      String key = Parser.ATTRIBUTE + ":properties";
      int pos = parser.indexOf(key);

      if (pos < 0)
      {
         // ups, did not find generic get method. 
         //         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for creator class for " + clazz.getFullName() 
         //            + ": \nDid not find properties field. Should have been generated by my clazz. " 
         //            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int endOfStringArrayInit = parser.getEndOfAttributeInitialization();
      
      String propertyName = "PROPERTY_" + partnerRole.getName().toUpperCase() +",";
      
      int propertyNameIndex = parser.search(propertyName, pos);

      if (propertyNameIndex < 0 || propertyNameIndex > endOfStringArrayInit)
      {         
         // need to add property to string array
         
         StringBuilder text = new StringBuilder(  "   className.PROPERTY_NAME,\n   ");

         String shortClassName = CGUtil.shortClassName(model.getClazz().getName(false));
         CGUtil.replaceAll(text, 
            "className", shortClassName,
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(endOfStringArrayInit, text.toString());
         parser.insertImport(model.getClazz().getName(false));
      }
   }
   
   private void insertCaseInGenericSetToMany(Clazz clazz, Parser parser, Association partnerRole, String rootDir)
   {   
      if (GraphUtil.isInterface(clazz))
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":setValue(Object,String,Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         //         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
         //            + ": \nDid not find method set(String,Object). Should have been generated by my clazz. " 
         //            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic set method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).withPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n      " + 
               "\n      if ((ClassName.PROPERTY_NAME + IdMap.REMOVE).equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).withoutPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n" 
               );

         String typePlaceholder = "type";
         String type = partnerRole.getClazz().getName(true);

         CGUtil.replaceAll(text, 
            typePlaceholder, type, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", StrUtil.upFirstChar(partnerRole.getName()),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
         
         parser.insertImport(IdMap.class.getName());
         parser.insertImport(partnerRole.getClazz().getName(false));
         
      }
   }

   private void insertCaseInGenericSetToOne(Clazz clazz, Parser parser, Association partnerRole, String rootDir)
   {
      if (GraphUtil.isInterface(clazz))
      {
         return;
      }
      
      int pos = parser.indexOf(Parser.METHOD + ":setValue(Object,String,Object,String)");

      if (pos < 0)
      {
         // ups, did not find generic set method. 
         //         System.err.println("Warning: SDMLib codgen for role " + partnerRole.getName() + " for class " + clazz.getFullName() 
         //            + ": \nDid not find method set(String,Object). Should have been generated by my clazz. " 
         //            + "\nCould not add required code fragment there. :( ");

         return;
      }

      // OK, found method, parse its body to find if that handles me. 
      int methodBodyStartPos = parser.getMethodBodyStartPos();
      
      pos = parser.methodBodyIndexOf(Parser.NAME_TOKEN + ":PROPERTY_" + partnerRole.getName().toUpperCase() , methodBodyStartPos);

      if (pos < 0)
      {         
         // need to add if block to generic set method
         parser.methodBodyIndexOf(Parser.METHOD_END, methodBodyStartPos);
         
         int lastIfEndPos = parser.lastIfEnd + 2; // add 1 to be after } and 1 to be after \n
         if (lastIfEndPos - 2  < 0)
         {
            lastIfEndPos = methodBodyStartPos + 1;
         }
         
         StringBuilder text = new StringBuilder
            (  "\n      if (ClassName.PROPERTY_NAME.equalsIgnoreCase(attrName))" +
               "\n      {" +
               "\n         ((ClassName) target).setPropertyName((type) value);" +
               "\n         return true;" +
               "\n      }" +
               "\n" 
               );

         String typePlaceholder = "type";
         String type = partnerRole.getClazz().getName(true);

         CGUtil.replaceAll(text, 
            typePlaceholder, type, 
            "ClassName", CGUtil.shortClassName(clazz.getName()),
            "PropertyName", StrUtil.upFirstChar(partnerRole.getName()),
            "PROPERTY_NAME", "PROPERTY_" + partnerRole.getName().toUpperCase()
            );

         parser.insert(lastIfEndPos, text.toString());
         parser.insertImport(partnerRole.getClazz().getName(false));
      }
   }
   
   public String toString()
   {
      return "gen " + model.toString();
   }

   /**
    * Deletes the generated code of the associated role, within the corresponding model, set, creator and pattern object classes.
    * 
    * 
    * @param rootDir root directory, where the code of the associated role is located
    */
   public void removeGeneratedCode(String rootDir) {
	   
	   GenClazzEntity genClass = getGenerator(this.getModel().getClazz());
	   
	   Parser parser = genClass.getParser();	   
   
	   String roleName = StrUtil.upFirstChar(this.getModel().getOther().getName());
	   
	   String cardType = "";
	   
	   if (this.getModel().getOther().getCardinality() == Cardinality.MANY) {
		   cardType = "...";
	   }
	   
	   String partnerClass = "" + this.getModel().getOtherClazz();
	   
	   String roleWithCard = partnerClass + cardType;
	   
	   String partnerPO = partnerClass + "PO";
	   
	   String partnerProperty = "PROPERTY_" + this.getModel().getOther().getName().toUpperCase();
	   
	   genClass.removeFragment(parser, Parser.ATTRIBUTE + ":" + partnerProperty);
	   
	   genClass.removeFragment(parser, Parser.ATTRIBUTE + ":" + this.getModel().getOther().getName());
	   
	   genClass.removeFragment(parser, Parser.METHOD + ":get" + roleName + "()");
	   
	   genClass.removeFragment(parser, Parser.METHOD + ":set" + roleName + "(" + roleWithCard + ")");
	   
	   genClass.removeFragment(parser, Parser.METHOD + ":with" + roleName + "(" + roleWithCard + ")");
	   
	   genClass.removeFragment(parser, Parser.METHOD + ":without" + roleName + "(" + roleWithCard + ")");
	   
	   genClass.removeFragment(parser, Parser.METHOD + ":create" + roleName + "()");
	   
	   genClass.removeLineFromFragment(parser, Parser.METHOD + ":removeYou()", roleName, roleName);
	   
	   CGUtil.printFile(parser);
	   
	   Parser creatorParser = genClass.getOrCreateParserForCreatorClass(rootDir);
	   
	   genClass.removeLineFromFragment(creatorParser, Parser.ATTRIBUTE + ":properties", partnerProperty, partnerProperty);
	   
	   genClass.removeLineFromFragment(creatorParser, Parser.METHOD + ":getValue(Object,String)" , partnerProperty, "}");
	   
	   genClass.removeLineFromFragment(creatorParser, Parser.METHOD + ":setValue(Object,String,Object,String)" , partnerProperty, "}");
	  
	   genClass.removeLineFromFragment(creatorParser, Parser.METHOD + ":setValue(Object,String,Object,String)" , partnerProperty, "}");
	   
	   CGUtil.printFile(creatorParser);
	   
	   Parser poParser = genClass.getOrCreateParserForPatternObjectFile(rootDir);
	   
	   genClass.removeFragment(poParser, Parser.METHOD + ":filter" + roleName + "()");
	   
	   genClass.removeFragment(poParser, Parser.METHOD + ":create" + roleName + "()");
	   
	   genClass.removeFragment(poParser, Parser.METHOD + ":get" + roleName + "()");
	   
	   genClass.removeFragment(poParser, Parser.METHOD + ":filter" + roleName + "(" + partnerPO + ")");
	   
	   genClass.removeFragment(poParser, Parser.METHOD + ":create" + roleName + "(" + partnerPO + ")");
	   
	   CGUtil.printFile(poParser);
	   
	   Parser setParser = genClass.getOrCreateParserForModelSetFile(rootDir);
	   
	   genClass.removeFragment(setParser, Parser.METHOD + ":get" + roleName + "()");
	   
	   genClass.removeFragment(setParser, Parser.METHOD + ":filter" + roleName + "(Object)");
	   
	   genClass.removeFragment(setParser, Parser.METHOD + ":with" + roleName + "(" + partnerClass + ")");
	   
	   genClass.removeFragment(setParser, Parser.METHOD + ":without" + roleName + "(" + partnerClass + ")");
	   
	   CGUtil.printFile(setParser);
	   
   }
	@Override
	ClassModel getClazz() {
		Clazz clazz = (Clazz) this.getModel().getClazz();
		return (ClassModel)clazz.getClassModel();
	}

	public GenAssociation generate(String rootDir, String helperDir) {
		// open source class and get or insert role implementation
//		ClassModel classModel = (ClassModel) ((Clazz) model.getClazz()).getClassModel();
//		ClassModelAdapter generator = classModel.getGenerator();
//		GenRole sourceGenRole = generator.getOrCreate((Clazz) model.getClazz());
		if(model.getOther().getType()==AssociationTypes.EDGE || model.getOther().getType()==AssociationTypes.GENERALISATION) {
			return this;
		}
		if(model.getOther().getType()==AssociationTypes.EDGE || model.getOther().getType()==AssociationTypes.IMPLEMENTS) {
			return this;
		}
		this.generate(rootDir, helperDir, model.getOther());
		if(model.getOtherClazz() == model.getClazz()) {
			this.generate(rootDir, helperDir, model);
		}

		// also for subclasses
		Clazz clazz = model.getClazz();
		for (Clazz kidClass : clazz.getKidClazzes(true)) {
			if (GraphUtil.isInterface(kidClass)) {
				continue;
			}

			boolean needsImplementation = kidClass.getInterfaces(false).contains(model.getClazz());
			// GenAssociation otherGen = this.getGenerator(model.getOther());
			this.generate(kidClass, rootDir, helperDir, model.getOther(), !needsImplementation);
		}

		if (model.getName() == null || model.getType()==AssociationTypes.EDGE) {
			// uni directional assoc, do not generate reverse direction
			return this;
		}

//		GenRole targetGenRole = generator.getOrCreate(model.getTarget());
		// open target class and get or insert role implementation
//		this.generate(rootDir, helperDir, model);
//		targetGenRole.generate(rootDir, helperDir, model.getSource());

		// also for subclasses
		for (Clazz kidClass : model.getOtherClazz().getKidClazzes(true)) {
			if (GraphUtil.isInterface(kidClass)) {
				continue;
			}

			boolean needsImplementation = kidClass.getInterfaces(false).contains(model.getOtherClazz());
			GenAssociation otherGen = this.getGenerator(model.getOther());
			otherGen.generate(kidClass, rootDir, helperDir, model, !needsImplementation);
		}
		return this;
	}
}
