package org.sdmlib.models.pattern.util;

import org.sdmlib.models.pattern.AttributeConstraint;
import org.sdmlib.models.pattern.CloneOp;
import org.sdmlib.models.pattern.Pattern;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;

public class CloneOpPO extends PatternObject<CloneOpPO, CloneOp>
{
   public CloneOpPO(){
      newInstance(CreatorCreator.createIdMap("PatternObjectType"));
   }

   public CloneOpPO(CloneOp... hostGraphObject) {
      if(hostGraphObject==null || hostGraphObject.length<1){
         return ;
      }
      newInstance(CreatorCreator.createIdMap("PatternObjectType"), hostGraphObject);
  }
   public CloneOpSet allMatches()
   {
      this.setDoAllMatches(true);
      
      CloneOpSet matches = new CloneOpSet();

      while (this.getPattern().getHasMatch())
      {
         matches.add((CloneOp) this.getCurrentMatch());
         
         this.getPattern().findMatch();
      }
      
      return matches;
   }
   
   public CloneOpPO hasModifier(String value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_MODIFIER)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public String getModifier()
   {
      if (this.getPattern().getHasMatch())
      {
         return ((CloneOp) getCurrentMatch()).getModifier();
      }
      return null;
   }
   
   public CloneOpPO withModifier(String value)
   {
      if (this.getPattern().getHasMatch())
      {
         ((CloneOp) getCurrentMatch()).setModifier(value);
      }
      return this;
   }
   
   public CloneOpPO hasHasMatch(boolean value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_HASMATCH)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public boolean getHasMatch()
   {
      if (this.getPattern().getHasMatch())
      {
         return ((CloneOp) getCurrentMatch()).getHasMatch();
      }
      return false;
   }
   
   public CloneOpPO withHasMatch(boolean value)
   {
      if (this.getPattern().getHasMatch())
      {
         ((CloneOp) getCurrentMatch()).setHasMatch(value);
      }
      return this;
   }
   
   public CloneOpPO hasPatternObjectName(String value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_PATTERNOBJECTNAME)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public String getPatternObjectName()
   {
      if (this.getPattern().getHasMatch())
      {
         return ((CloneOp) getCurrentMatch()).getPatternObjectName();
      }
      return null;
   }
   
   public CloneOpPO withPatternObjectName(String value)
   {
      if (this.getPattern().getHasMatch())
      {
         ((CloneOp) getCurrentMatch()).setPatternObjectName(value);
      }
      return this;
   }
   
   public CloneOpPO hasDoAllMatches(boolean value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_DOALLMATCHES)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public boolean getDoAllMatches()
   {
      if (this.getPattern().getHasMatch())
      {
         return ((CloneOp) getCurrentMatch()).getDoAllMatches();
      }
      return false;
   }
   
   public CloneOpPO withDoAllMatches(boolean value)
   {
      if (this.getPattern().getHasMatch())
      {
         ((CloneOp) getCurrentMatch()).setDoAllMatches(value);
      }
      return this;
   }
   
   public PatternPO hasPattern()
   {
      PatternPO result = new PatternPO();
      
      result.setModifier(this.getPattern().getModifier());
      super.hasLink(PatternElement.PROPERTY_PATTERN, result);
      
      return result;
   }

   public CloneOpPO hasPattern(PatternPO tgt)
   {
      return hasLinkConstraint(tgt, PatternElement.PROPERTY_PATTERN);
   }

   public Pattern getPattern()
   {
      if (super.getPattern().getHasMatch())
      {
         return ((PatternElement) this.getCurrentMatch()).getPattern();
      }
      return super.getPattern();
   }

   public CloneOpPO hasModifier(String lower, String upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_MODIFIER)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public CloneOpPO hasHasMatch(boolean lower, boolean upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_HASMATCH)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public CloneOpPO hasPatternObjectName(String lower, String upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_PATTERNOBJECTNAME)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public CloneOpPO hasDoAllMatches(boolean lower, boolean upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_DOALLMATCHES)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      this.getPattern().findMatch();
      
      return this;
   }
   
   public CloneOpPO createModifier(String value)
   {
      this.startCreate().hasModifier(value).endCreate();
      return this;
   }
   
   public CloneOpPO createHasMatch(boolean value)
   {
      this.startCreate().hasHasMatch(value).endCreate();
      return this;
   }
   
   public CloneOpPO createPatternObjectName(String value)
   {
      this.startCreate().hasPatternObjectName(value).endCreate();
      return this;
   }
   
   public CloneOpPO createDoAllMatches(boolean value)
   {
      this.startCreate().hasDoAllMatches(value).endCreate();
      return this;
   }
   
   public PatternPO createPattern()
   {
      return (PatternPO) this.startCreate().hasPattern().endCreate();
   }

   public CloneOpPO createPattern(PatternPO tgt)
   {
      return this.startCreate().hasPattern(tgt).endCreate();
   }

   public CloneOpPO filterModifier(String value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_MODIFIER)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
   public CloneOpPO filterModifier(String lower, String upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_MODIFIER)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
   public CloneOpPO filterHasMatch(boolean value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_HASMATCH)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
   public CloneOpPO filterPatternObjectName(String value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_PATTERNOBJECTNAME)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
   public CloneOpPO filterPatternObjectName(String lower, String upper)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_PATTERNOBJECTNAME)
      .withTgtValue(lower)
      .withUpperTgtValue(upper)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
   public CloneOpPO filterDoAllMatches(boolean value)
   {
      new AttributeConstraint()
      .withAttrName(CloneOp.PROPERTY_DOALLMATCHES)
      .withTgtValue(value)
      .withSrc(this)
      .withModifier(this.getPattern().getModifier())
      .withPattern(this.getPattern());
      
      super.filterAttr();
      
      return this;
   }
   
}



