/*
 * Copyright (c) 2013-2016, The SeedStack authors <http://seedstack.org>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

var tests = [];

for (var file in window.__karma__.files) {
    if (/.spec\.js$/.test(file)) {
        tests.push(file);
    }
}

window.w20 = {
    configuration: {
        '/base/node_modules/@w20/w20/w20-core.w20.json': {
            modules: {
                application: {
                    id: 'w20-test',
                    home: '/test'
                }
            },
            vars: {
                'components-path': '/base/node_modules'
            }
        },
        'base/w20-extra.w20.json': {
            modules: {
                analytics: {
                    provider: 'piwik',
                    virtualPageViews: true,
                    settings: {
                        jsUrl: '/base/specs/mock-piwik.js',
                        trackerUrl: 'url/of/tracker.url',
                        siteId: 1
                    }
                }
            },
            vars: {
                'components-path': '/base/node_modules'
            }
        }
    },
    deps: tests,
    callback: window.__karma__.start
};

requirejs.config({
    paths: {
        '{angular-mocks}': '/base/node_modules/angular-mocks'
    },
    shim: {
        '{angular-mocks}/angular-mocks': [ '{angular}/angular' ]
    }
});

requirejs([ '/base/node_modules/@w20/w20/modules/w20.js' ]);


