/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.seedstack.coffig.Config;
import org.seedstack.jms.JmsConfig;
import org.seedstack.jms.spi.MessagePoller;

@Config(value="webServices")
public class WebServicesJmsConfig {
    private Map<String, JmsEndpointConfig> endpoints = new HashMap<String, JmsEndpointConfig>();
    private JmsConfig jms = new JmsConfig();

    public Map<String, JmsEndpointConfig> getEndpoints() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    public WebServicesJmsConfig addEndpoint(String name, JmsEndpointConfig endpointConfig) {
        this.endpoints.put(name, endpointConfig);
        return this;
    }

    public JmsConfig jms() {
        return this.jms;
    }

    @Config(value="jms")
    public static class JmsConfig {
        private static final int DEFAULT_TIMEOUT_INTERVAL = 30000;
        private int clientTimeout = 30000;
        private CacheConfig connectionCache = new CacheConfig();

        public int getClientTimeout() {
            return this.clientTimeout;
        }

        public JmsConfig setClientTimeout(int clientTimeout) {
            this.clientTimeout = clientTimeout;
            return this;
        }

        public CacheConfig connectionCache() {
            return this.connectionCache;
        }

        @Config(value="connectionCache")
        public static class CacheConfig {
            private static final int DEFAULT_CACHE_CONCURRENCY = 4;
            private static final int DEFAULT_CACHE_MAX_SIZE = 16;
            private int maxSize = 16;
            private int initialSize = this.maxSize / 4;
            private int concurrencyLevel = 4;

            public int getInitialSize() {
                return this.initialSize;
            }

            public CacheConfig setInitialSize(int initialSize) {
                this.initialSize = initialSize;
                return this;
            }

            public int getMaxSize() {
                return this.maxSize;
            }

            public CacheConfig setMaxSize(int maxSize) {
                this.maxSize = maxSize;
                return this;
            }

            public int getConcurrencyLevel() {
                return this.concurrencyLevel;
            }

            public CacheConfig setConcurrencyLevel(int concurrencyLevel) {
                this.concurrencyLevel = concurrencyLevel;
                return this;
            }
        }
    }

    public static class JmsEndpointConfig {
        private JmsConfig jms = new JmsConfig();

        public JmsConfig jms() {
            return this.jms;
        }

        public static class JmsConfig {
            private JmsConfig.ConnectionConfig connection = new JmsConfig.ConnectionConfig();
            private boolean transactional = true;
            private String selector;
            private Class<? extends MessagePoller> messagePoller;

            public JmsConfig.ConnectionConfig getConnection() {
                return this.connection;
            }

            public JmsConfig setConnection(JmsConfig.ConnectionConfig connection) {
                this.connection = connection;
                return this;
            }

            public boolean isTransactional() {
                return this.transactional;
            }

            public void setTransactional(boolean transactional) {
                this.transactional = transactional;
            }

            public String getSelector() {
                return this.selector;
            }

            public JmsConfig setSelector(String selector) {
                this.selector = selector;
                return this;
            }

            public Class<? extends MessagePoller> getMessagePoller() {
                return this.messagePoller;
            }

            public JmsConfig setMessagePoller(Class<? extends MessagePoller> messagePoller) {
                this.messagePoller = messagePoller;
                return this;
            }
        }
    }
}

