/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.server.Adapter;
import com.sun.xml.ws.api.server.TransportBackChannel;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.xml.ws.WebServiceException;
import org.seedstack.ws.jms.internal.JmsServerTransport;
import org.seedstack.ws.jms.internal.SoapJmsUri;
import org.seedstack.ws.jms.internal.WSJmsTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsAdapter
extends Adapter<JMSToolkit> {
    private static Logger LOGGER = LoggerFactory.getLogger(JmsAdapter.class);
    @Inject
    private WSJmsTransportFactory wsJmsTransportFactory;

    JmsAdapter(WSEndpoint endpoint) {
        super(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handle(javax.jms.Message requestMessage, SoapJmsUri uri) throws IOException, JMSException {
        JmsServerTransport connection = this.wsJmsTransportFactory.createJmsServerTransport(requestMessage, uri);
        JMSToolkit tk = (JMSToolkit)((Object)this.pool.take());
        try {
            tk.handle(connection);
            connection.flush();
        }
        finally {
            this.pool.recycle((Object)tk);
            connection.close();
        }
    }

    protected JMSToolkit createToolkit() {
        return new JMSToolkit();
    }

    final class JMSToolkit
    extends Adapter.Toolkit
    implements TransportBackChannel {
        private final Pattern charsetPattern;
        private JmsServerTransport connection;

        JMSToolkit() {
            super((Adapter)JmsAdapter.this);
            this.charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");
        }

        private void handle(JmsServerTransport connection) throws IOException {
            this.connection = connection;
            InputStream in = connection.getInputStream();
            Packet packet = new Packet();
            this.codec.decode(in, connection.getRequestContentType(), packet);
            packet.invocationProperties.put("javax.xml.ws.security.auth.username", connection.getRequestUsername());
            packet.invocationProperties.put("javax.xml.ws.security.auth.password", connection.getRequestPassword());
            try {
                packet = this.head.process(packet, (WebServiceContextDelegate)connection, (TransportBackChannel)this);
            }
            catch (Exception e) {
                throw new WebServiceException("Error during message processing", (Throwable)e);
            }
            Message packetMessage = packet.getMessage();
            if (packetMessage != null) {
                if (packetMessage.isFault() && !connection.canReply()) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ContentType faultContentType = this.codec.encode(packet, (OutputStream)byteArrayOutputStream);
                    LOGGER.warn("A SOAP fault has been generated but cannot be returned to client:\n\t{}", (Object)byteArrayOutputStream.toString(this.getCharsetFromContentType(faultContentType.getContentType())));
                } else {
                    connection.setMustReply(true);
                    ContentType contentType = this.codec.getStaticContentType(packet);
                    if (contentType != null) {
                        connection.setResponseContentType(contentType.getContentType());
                        this.codec.encode(packet, connection.getOutputStream());
                    } else {
                        contentType = this.codec.encode(packet, connection.getOutputStream());
                        connection.setResponseContentType(contentType.getContentType());
                    }
                }
            }
        }

        public void close() {
            this.connection.close();
        }

        private String getCharsetFromContentType(String contentType) {
            if (contentType == null) {
                return null;
            }
            Matcher m = this.charsetPattern.matcher(contentType);
            if (m.find()) {
                return m.group(1).trim().toUpperCase();
            }
            return null;
        }
    }
}

