/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.common.cache.LoadingCache;
import com.google.inject.assistedinject.Assisted;
import com.sun.xml.ws.api.message.Packet;
import java.net.URI;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.ws.WebServiceException;
import org.seedstack.seed.Application;
import org.seedstack.ws.jms.WebServicesJmsConfig;
import org.seedstack.ws.jms.internal.JmsTransportException;
import org.seedstack.ws.jms.internal.SoapJmsUri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsClientTransport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsClientTransport.class);
    private static final String MESSAGE_TYPE_BYTES = "bytes";
    private static final String MESSAGE_TYPE_TEXT = "text";
    private final int responseTimeout;
    private final LoadingCache<SoapJmsUri, Connection> connectionCache;
    private final Packet packet;
    private final Map<String, String> requestHeaders;
    private String requestMessageId;
    private String replyMessageId;
    private String correlationId;
    private Message replyMessage;

    @Inject
    JmsClientTransport(Application application, LoadingCache<SoapJmsUri, Connection> connectionCache, @Assisted Packet packet, @Assisted Map<String, String> requestHeaders) {
        this.packet = packet;
        this.requestHeaders = requestHeaders;
        this.responseTimeout = ((WebServicesJmsConfig)application.getConfiguration().get(WebServicesJmsConfig.class, new String[0])).jms().getClientTimeout();
        this.connectionCache = connectionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] sendMessage(byte[] sndPacket) {
        block43: {
            Connection connection;
            Session session = null;
            MessageConsumer messageConsumer = null;
            URI uri = this.packet.endpointAddress.getURI();
            SoapJmsUri destinationAddress = SoapJmsUri.parse(uri);
            try {
                connection = (Connection)this.connectionCache.get((Object)destinationAddress);
            }
            catch (ExecutionException e) {
                throw new JmsTransportException("Failed to open JMS transport to " + destinationAddress, e);
            }
            try {
                Object bytesReplyMessage;
                block44: {
                    try {
                        BytesMessage message;
                        String messageType;
                        String priority;
                        String timeToLive;
                        session = connection.createSession(false, 1);
                        MessageProducer producer = session.createProducer(SoapJmsUri.getDestination(destinationAddress, session));
                        String deliveryMode = destinationAddress.getParameter("deliveryMode");
                        if (deliveryMode != null) {
                            if ("PERSISTENT".equals(deliveryMode)) {
                                producer.setDeliveryMode(2);
                            } else if ("NON_PERSISTENT".equals(deliveryMode)) {
                                producer.setDeliveryMode(1);
                            } else {
                                throw new JmsTransportException("Unknown delivery mode " + deliveryMode);
                            }
                        }
                        if ((timeToLive = destinationAddress.getParameter("timeToLive")) != null) {
                            try {
                                producer.setTimeToLive(Long.parseLong(timeToLive));
                            }
                            catch (NumberFormatException e) {
                                throw new JmsTransportException("Unable to set message time to live", e);
                            }
                        }
                        if ((priority = destinationAddress.getParameter("priority")) != null) {
                            try {
                                producer.setPriority(Integer.parseInt(priority));
                            }
                            catch (NumberFormatException e) {
                                throw new JmsTransportException("Unable to set message priority", e);
                            }
                        }
                        if ((messageType = destinationAddress.getParameter("messageType")) == null || MESSAGE_TYPE_BYTES.equalsIgnoreCase(messageType)) {
                            message = session.createBytesMessage();
                        } else if (MESSAGE_TYPE_TEXT.equalsIgnoreCase(messageType)) {
                            message = session.createTextMessage();
                        } else {
                            throw new JmsTransportException(String.format("Unknown message type %s, specify '%s' or '%s'", messageType, MESSAGE_TYPE_BYTES, MESSAGE_TYPE_TEXT));
                        }
                        for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
                            message.setStringProperty(entry.getKey(), entry.getValue());
                        }
                        if (this.packet.expectReply.booleanValue()) {
                            this.correlationId = UUID.randomUUID().toString();
                            Destination replyDestination = SoapJmsUri.getReplyToDestination(destinationAddress, session);
                            if (replyDestination == null) {
                                replyDestination = session.createTemporaryQueue();
                            }
                            message.setJMSCorrelationID(this.correlationId);
                            message.setJMSReplyTo(replyDestination);
                            messageConsumer = session.createConsumer(replyDestination, String.format("JMSCorrelationID='%s'", this.correlationId));
                        }
                        if (message instanceof BytesMessage) {
                            message.writeBytes(sndPacket);
                        } else {
                            ((TextMessage)message).setText(new String(sndPacket, this.findCharset(this.requestHeaders.get("SOAPJMS_contentType"))));
                        }
                        producer.send((Message)message);
                        this.requestMessageId = message.getJMSMessageID();
                        producer.close();
                    }
                    catch (Exception e) {
                        throw new JmsTransportException("Error sending JMS message", e);
                    }
                    if (messageConsumer == null) break block43;
                    try {
                        this.replyMessage = messageConsumer.receive((long)this.responseTimeout);
                        this.replyMessageId = this.replyMessage.getJMSMessageID();
                        if (!(this.replyMessage instanceof BytesMessage)) break block44;
                        bytesReplyMessage = (BytesMessage)this.replyMessage;
                        byte[] buffer = new byte[(int)bytesReplyMessage.getBodyLength()];
                        bytesReplyMessage.readBytes(buffer);
                        byte[] byArray = buffer;
                        return byArray;
                    }
                    catch (Exception e) {
                        throw new JmsTransportException("Error receiving JMS message", e);
                    }
                }
                if (this.replyMessage instanceof TextMessage) {
                    bytesReplyMessage = ((TextMessage)this.replyMessage).getText().getBytes(this.findCharset(this.getResponseContentType()));
                    return bytesReplyMessage;
                }
                throw new JmsTransportException("No suitable reply received");
            }
            finally {
                try {
                    if (messageConsumer != null) {
                        messageConsumer.close();
                    }
                    if (session != null) {
                        session.close();
                    }
                }
                catch (JMSException e) {
                    LOGGER.warn("Unable to close JMS transport after WS send/receive", (Throwable)e);
                }
            }
        }
        return null;
    }

    private String findCharset(String contentType) throws MimeTypeParseException {
        String charset = null;
        if (contentType != null && !contentType.isEmpty()) {
            charset = new MimeType(contentType).getParameter("charset");
        }
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        return charset;
    }

    String getResponseContentType() {
        if (this.replyMessage != null) {
            try {
                return this.replyMessage.getStringProperty("SOAPJMS_contentType");
            }
            catch (JMSException e) {
                throw new WebServiceException("Error trying to get content type from response", (Throwable)e);
            }
        }
        throw new WebServiceException("No response available");
    }

    String getRequestMessageId() {
        return this.requestMessageId;
    }

    String getReplyMessageId() {
        return this.replyMessageId;
    }

    String getCorrelationId() {
        return this.correlationId;
    }
}

