/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.common.cache.LoadingCache;
import com.google.inject.assistedinject.Assisted;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.inject.Inject;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.seedstack.ws.jms.internal.JmsTransportException;
import org.seedstack.ws.jms.internal.SoapJmsUri;

class JmsServerTransport
implements WebServiceContextDelegate {
    private final LoadingCache<SoapJmsUri, Connection> connectionCache;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final SoapJmsUri soapJmsUri;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final String requestContentType;
    private final Destination replyTo;
    private final String correlationID;
    private final String username;
    private final String password;
    private final boolean replyAsText;
    private String responseContentType;
    private boolean mustReply;

    @Inject
    JmsServerTransport(LoadingCache<SoapJmsUri, Connection> connectionCache, @Assisted Message requestMessage, @Assisted SoapJmsUri soapJmsUri) throws JMSException {
        this.connectionCache = connectionCache;
        this.soapJmsUri = soapJmsUri;
        this.outputStream = new ByteArrayOutputStream();
        this.username = requestMessage.getStringProperty("javax.xml.ws.security.auth.username");
        this.password = requestMessage.getStringProperty("javax.xml.ws.security.auth.password");
        this.requestContentType = requestMessage.getStringProperty("SOAPJMS_contentType");
        this.replyTo = requestMessage.getJMSReplyTo();
        this.correlationID = requestMessage.getJMSCorrelationID();
        this.inputStream = this.readMessage(requestMessage);
        this.replyAsText = requestMessage instanceof TextMessage;
    }

    private ByteArrayInputStream readMessage(Message requestMessage) throws JMSException {
        if (requestMessage instanceof BytesMessage) {
            long bodyLength = ((BytesMessage)requestMessage).getBodyLength();
            if (bodyLength > Integer.MAX_VALUE) {
                throw new JmsTransportException("JMS message too long");
            }
            byte[] rqstBuf = new byte[(int)bodyLength];
            ((BytesMessage)requestMessage).readBytes(rqstBuf);
            return new ByteArrayInputStream(rqstBuf);
        }
        if (requestMessage instanceof TextMessage) {
            try {
                return new ByteArrayInputStream(((TextMessage)requestMessage).getText().getBytes(this.findCharset(this.requestContentType)));
            }
            catch (Exception e) {
                throw new JmsTransportException("Unable to decode JMS text message", e);
            }
        }
        throw new IllegalStateException("Unknown message type (only byte messages and text messages are supported)");
    }

    private String findCharset(String contentType) throws MimeTypeParseException {
        String charset = null;
        if (contentType != null && !contentType.isEmpty()) {
            charset = new MimeType(contentType).getParameter("charset");
        }
        if (charset == null || charset.isEmpty()) {
            charset = "UTF-8";
        }
        return charset;
    }

    InputStream getInputStream() {
        return this.inputStream;
    }

    OutputStream getOutputStream() {
        return this.outputStream;
    }

    void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.inputStream.close();
                this.outputStream.close();
            }
            catch (IOException e) {
                throw new JmsTransportException("Unable to close JMS transport", e);
            }
        }
    }

    public Principal getUserPrincipal(Packet request) {
        return null;
    }

    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        return this.soapJmsUri.toString();
    }

    public String getWSDLAddress(Packet request, WSEndpoint endpoint) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException, JMSException {
        this.outputStream.flush();
        if (this.mustReply) {
            Session jmsSession;
            try {
                Connection connection = (Connection)this.connectionCache.get((Object)this.soapJmsUri);
                jmsSession = connection.createSession(false, 1);
            }
            catch (ExecutionException e) {
                throw new JmsTransportException("Unable to open JMS transport for reply to " + this.soapJmsUri, e);
            }
            try {
                Object replyMessage = !this.replyAsText ? jmsSession.createBytesMessage() : jmsSession.createTextMessage();
                replyMessage.setJMSCorrelationID(this.correlationID);
                replyMessage.setStringProperty("SOAPJMS_contentType", this.responseContentType);
                byte[] content = ((ByteArrayOutputStream)this.getOutputStream()).toByteArray();
                if (content.length > 0) {
                    if (replyMessage instanceof BytesMessage) {
                        replyMessage.writeBytes(content);
                    } else {
                        try {
                            ((TextMessage)replyMessage).setText(new String(content, this.findCharset(this.responseContentType)));
                        }
                        catch (Exception e) {
                            throw new JmsTransportException("Unable to encode text message for reply to " + this.soapJmsUri, e);
                        }
                    }
                }
                MessageProducer messageProducer = jmsSession.createProducer(this.replyTo);
                messageProducer.send((Message)replyMessage);
                messageProducer.close();
            }
            finally {
                jmsSession.close();
            }
        }
    }

    String getRequestUsername() {
        return this.username;
    }

    String getRequestPassword() {
        return this.password;
    }

    String getRequestContentType() {
        return this.requestContentType;
    }

    boolean canReply() {
        return this.replyTo != null;
    }

    void setResponseContentType(String value) {
        this.responseContentType = value;
    }

    void setMustReply(boolean mustReply) {
        this.mustReply = mustReply;
    }
}

