/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.inject.assistedinject.Assisted;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.seedstack.ws.jms.internal.JmsClientTransport;
import org.seedstack.ws.jms.internal.WSJmsTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsTransportTube
extends AbstractTubeImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsTransportTube.class);
    private final Codec codec;
    private final QName serviceName;
    @Inject
    private WSJmsTransportFactory wsJmsTransportFactory;

    @Inject
    JmsTransportTube(@Assisted Codec codec, @Assisted QName serviceName) {
        this.codec = codec;
        this.serviceName = serviceName;
    }

    protected JmsTransportTube(JmsTransportTube that, TubeCloner cloner) {
        super((AbstractTubeImpl)that, cloner);
        this.serviceName = that.serviceName;
        this.codec = that.codec.copy();
    }

    public void preDestroy() {
    }

    public JmsTransportTube copy(TubeCloner cloner) {
        return new JmsTransportTube(this, cloner);
    }

    public NextAction processRequest(Packet request) {
        ByteArrayInputStream replyPacketInStream = null;
        ByteArrayOutputStream requestPacketOutStream = null;
        try {
            String correlationId;
            String replyMessageId;
            String soapActionHeader;
            HashMap<String, String> reqHeaders = (HashMap<String, String>)request.invocationProperties.get("JMS-RQ-Headers");
            if (reqHeaders == null) {
                reqHeaders = new HashMap<String, String>();
            }
            JmsClientTransport con = this.wsJmsTransportFactory.createJmsClientTransport(request, reqHeaders);
            ContentType ct = this.codec.getStaticContentType(request);
            requestPacketOutStream = new ByteArrayOutputStream();
            ContentType dynamicCT = this.codec.encode(request, (OutputStream)requestPacketOutStream);
            if (ct == null) {
                ct = dynamicCT;
            }
            if ((soapActionHeader = ct.getSOAPActionHeader()) != null) {
                reqHeaders.put("SOAPJMS_soapAction", soapActionHeader);
            }
            reqHeaders.put("SOAPJMS_contentType", ct.getContentType());
            reqHeaders.put("SOAPJMS_requestURI", this.buildRequestURI(request.endpointAddress.getURI()));
            reqHeaders.put("SOAPJMS_targetService", this.serviceName.toString());
            reqHeaders.put("SOAPJMS_bindingVersion", "1.0");
            byte[] rplPacket = con.sendMessage(requestPacketOutStream.toByteArray());
            Packet reply = request.createClientResponse(null);
            String requestMessageId = con.getRequestMessageId();
            if (requestMessageId != null) {
                reply.invocationProperties.put("JMS-RQ-MessageId", requestMessageId);
            }
            if ((replyMessageId = con.getReplyMessageId()) != null) {
                reply.invocationProperties.put("JMS-RP-MessageId", replyMessageId);
            }
            if ((correlationId = con.getCorrelationId()) != null) {
                reply.invocationProperties.put("JMS-CorrelationId", correlationId);
            }
            if (rplPacket != null) {
                String contentTypeStr = con.getResponseContentType();
                replyPacketInStream = new ByteArrayInputStream(rplPacket);
                this.codec.decode((InputStream)replyPacketInStream, contentTypeStr, reply);
            }
            NextAction nextAction = this.doReturnWith(reply);
            return nextAction;
        }
        catch (WebServiceException wex) {
            throw wex;
        }
        catch (Exception ex) {
            throw new WebServiceException((Throwable)ex);
        }
        finally {
            if (requestPacketOutStream != null) {
                try {
                    requestPacketOutStream.close();
                    if (replyPacketInStream != null) {
                        replyPacketInStream.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to close I/O buffers after WS send/receive", (Throwable)e);
                }
            }
        }
    }

    public NextAction processResponse(Packet response) {
        throw new AssertionError();
    }

    public NextAction processException(Throwable t) {
        throw new AssertionError();
    }

    private String buildRequestURI(URI source) {
        String sourceAsString = source.toASCIIString();
        int queryIndex = sourceAsString.indexOf("?");
        if (queryIndex != -1) {
            return sourceAsString.substring(0, queryIndex);
        }
        return source.toASCIIString();
    }
}

