/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.binding.WebServiceFeatureList;
import com.sun.xml.ws.encoding.SOAPBindingCodec;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.MTOMFeature;

final class SoapJmsBindingID {
    static final SOAPJMSImpl SOAP12_JMS = new SOAPJMSImpl(SOAPVersion.SOAP_12, "http://www.w3.org/2010/soapjms/", true);
    static final SOAPJMSImpl SOAP12_JMS_MTOM = new SOAPJMSImpl(SOAPVersion.SOAP_12, "http://www.w3.org/2010/soapjms/", true, true);
    static final SOAPJMSImpl SOAP11_JMS = new SOAPJMSImpl(SOAPVersion.SOAP_11, "http://www.w3.org/2010/soapjms/", true);
    static final SOAPJMSImpl SOAP11_JMS_MTOM = new SOAPJMSImpl(SOAPVersion.SOAP_11, "http://www.w3.org/2010/soapjms/", true, true);

    private SoapJmsBindingID() {
    }

    private static final class SOAPJMSImpl
    extends Impl
    implements Cloneable {
        static final String MTOM_PARAM = "mtom";
        private final Map<String, String> parameters = new HashMap<String, String>();

        private SOAPJMSImpl(SOAPVersion version, String lexical, boolean canGenerateWSDL) {
            super(version, lexical, canGenerateWSDL);
        }

        private SOAPJMSImpl(SOAPVersion version, String lexical, boolean canGenerateWSDL, boolean mtomEnabled) {
            this(version, lexical, canGenerateWSDL);
            if (mtomEnabled) {
                this.parameters.put(MTOM_PARAM, "true");
            } else {
                this.parameters.put(MTOM_PARAM, "false");
            }
        }

        public Codec createEncoder(WSBinding binding) {
            return new SOAPBindingCodec(binding.getFeatures());
        }

        public WebServiceFeatureList createBuiltinFeatureList() {
            WebServiceFeatureList r = super.createBuiltinFeatureList();
            Boolean mtom = this.isMTOMEnabled();
            if (mtom != null) {
                r.add((WebServiceFeature)new MTOMFeature(mtom.booleanValue()));
            }
            return r;
        }

        public String getParameter(String parameterName, String defaultValue) {
            if (this.parameters.get(parameterName) == null) {
                return super.getParameter(parameterName, defaultValue);
            }
            return this.parameters.get(parameterName);
        }

        public SOAPJMSImpl clone() throws CloneNotSupportedException {
            return (SOAPJMSImpl)super.clone();
        }

        private Boolean isMTOMEnabled() {
            String mtom = this.parameters.get(MTOM_PARAM);
            if (mtom == null) {
                return null;
            }
            return Boolean.valueOf(mtom);
        }
    }

    private static abstract class Impl
    extends BindingID {
        final SOAPVersion version;
        private final String lexical;
        private final boolean canGenerateWSDL;

        private Impl(SOAPVersion version, String lexical, boolean canGenerateWSDL) {
            this.version = version;
            this.lexical = lexical;
            this.canGenerateWSDL = canGenerateWSDL;
        }

        public SOAPVersion getSOAPVersion() {
            return this.version;
        }

        public String toString() {
            return this.lexical;
        }

        public boolean canGenerateWSDL() {
            return this.canGenerateWSDL;
        }
    }
}

