/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.seedstack.ws.jms.WebServicesJmsConfig;

final class SoapJmsUri {
    public static final String JNDI_LOOKUP_VARIANT = "jndi";
    public static final String SEED_QUEUE_LOOKUP_VARIANT = "queue";
    public static final String SEED_TOPIC_LOOKUP_VARIANT = "topic";
    public static final String CONNECTION_NAME_PATTERN = "ws-%s-connection";
    private final String lookupVariant;
    private final String destinationName;
    private final Map<String, String[]> params;
    private final String uri2string;
    private String endpointName;

    private SoapJmsUri(String lookupVariant, String destinationName, Map<String, String[]> params, String uri2string) {
        this.lookupVariant = lookupVariant;
        this.destinationName = destinationName;
        this.params = params;
        this.uri2string = uri2string;
    }

    static Map<String, String[]> parseUrlQueryString(String s) {
        if (s == null) {
            return new HashMap<String, String[]>(0);
        }
        HashMap<String, Object> map1 = new HashMap<String, Object>();
        int p = 0;
        while (p < s.length()) {
            ArrayList<String> a;
            Object x;
            int p0 = p;
            while (p < s.length() && s.charAt(p) != '=' && s.charAt(p) != '&') {
                ++p;
            }
            String name = SoapJmsUri.urlDecode(s.substring(p0, p));
            if (p < s.length() && s.charAt(p) == '=') {
                ++p;
            }
            p0 = p;
            while (p < s.length() && s.charAt(p) != '&') {
                ++p;
            }
            String value = SoapJmsUri.urlDecode(s.substring(p0, p));
            if (p < s.length() && s.charAt(p) == '&') {
                ++p;
            }
            if ((x = map1.get(name)) == null) {
                map1.put(name, value);
                continue;
            }
            if (x instanceof String) {
                a = new ArrayList<String>();
                a.add((String)x);
                a.add(value);
                map1.put(name, a);
                continue;
            }
            a = (ArrayList<String>)x;
            a.add(value);
        }
        HashMap<String, String[]> map2 = new HashMap<String, String[]>(map1.size());
        for (Map.Entry e : map1.entrySet()) {
            String[] v;
            String name = (String)e.getKey();
            Object x = e.getValue();
            if (x instanceof String) {
                v = new String[]{(String)x};
            } else {
                ArrayList a = (ArrayList)x;
                v = new String[a.size()];
                v = a.toArray(v);
            }
            map2.put(name, v);
        }
        return map2;
    }

    static String urlDecode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Error in urlDecode.", e);
        }
    }

    static SoapJmsUri parse(URI uri) {
        if (!"jms".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Not a valid SOAP JMS URI " + uri.toString());
        }
        String ssp = uri.getSchemeSpecificPart();
        String[] splitSsp = ssp.split(":", 2);
        if (splitSsp.length != 2) {
            throw new IllegalArgumentException("Invalid SOAP JMS URI " + splitSsp[0]);
        }
        String[] splitSecondPart = splitSsp[1].split("\\?", 2);
        if (splitSecondPart.length != 2) {
            throw new IllegalArgumentException("Invalid SOAP JMS URI " + splitSsp[1]);
        }
        return new SoapJmsUri(splitSsp[0], splitSecondPart[0], SoapJmsUri.parseUrlQueryString(splitSecondPart[1]), uri.toASCIIString());
    }

    static Context getContext(SoapJmsUri soapJmsUri) throws NamingException {
        String jndiURL;
        Properties properties = new Properties();
        String jndiInitialContextFactory = soapJmsUri.getParameter("jndiInitialContextFactory");
        if (!StringUtils.isEmpty((String)jndiInitialContextFactory)) {
            properties.setProperty("java.naming.factory.initial", jndiInitialContextFactory);
        }
        if (!StringUtils.isEmpty((String)(jndiURL = soapJmsUri.getParameter("jndiURL")))) {
            properties.setProperty("java.naming.provider.url", jndiURL);
        }
        return new InitialContext(properties);
    }

    static Destination getDestination(SoapJmsUri soapJmsUri, Session session) throws NamingException, JMSException {
        Destination destination;
        String lookupVariant = soapJmsUri.getLookupVariant();
        if (JNDI_LOOKUP_VARIANT.equals(lookupVariant)) {
            destination = (Destination)SoapJmsUri.getContext(soapJmsUri).lookup(soapJmsUri.getDestinationName());
        } else if (SEED_QUEUE_LOOKUP_VARIANT.equals(lookupVariant)) {
            destination = session.createQueue(soapJmsUri.getDestinationName());
        } else if (SEED_TOPIC_LOOKUP_VARIANT.equals(lookupVariant)) {
            destination = session.createTopic(soapJmsUri.getDestinationName());
        } else {
            throw new IllegalArgumentException("Unsupported lookup variant " + lookupVariant + " for JMS URI " + soapJmsUri.toString());
        }
        return destination;
    }

    static Destination getReplyToDestination(SoapJmsUri soapJmsUri, Session session) throws NamingException, JMSException {
        Destination destination = null;
        String lookupVariant = soapJmsUri.getLookupVariant();
        if (JNDI_LOOKUP_VARIANT.equals(lookupVariant)) {
            String destinationName = soapJmsUri.getParameter("replyToName");
            if (destinationName != null) {
                destination = (Destination)SoapJmsUri.getContext(soapJmsUri).lookup(destinationName);
            }
        } else if (SEED_QUEUE_LOOKUP_VARIANT.equals(lookupVariant) || SEED_TOPIC_LOOKUP_VARIANT.equals(lookupVariant)) {
            String queueName = soapJmsUri.getParameter("replyToName");
            String topicName = soapJmsUri.getParameter("topicReplyToName");
            if (queueName != null) {
                destination = session.createQueue(queueName);
            } else if (topicName != null) {
                destination = session.createTopic(topicName);
            }
        } else {
            throw new IllegalArgumentException("Unsupported lookup variant " + lookupVariant + " for JMS URI " + soapJmsUri.toString());
        }
        return destination;
    }

    public String toString() {
        return this.uri2string;
    }

    String getParameter(String name) {
        String[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            return this.params.get(name)[0];
        }
        return null;
    }

    String getLookupVariant() {
        return this.lookupVariant;
    }

    String getDestinationName() {
        return this.destinationName;
    }

    String getEndpointName() {
        return this.endpointName;
    }

    void setEndpointName(String endpointName) {
        this.endpointName = endpointName;
    }

    String getConnectionName() {
        if (JNDI_LOOKUP_VARIANT.equals(this.lookupVariant)) {
            if (this.endpointName != null) {
                return String.format(CONNECTION_NAME_PATTERN, this.endpointName);
            }
        } else if (SEED_QUEUE_LOOKUP_VARIANT.equals(this.lookupVariant) || SEED_TOPIC_LOOKUP_VARIANT.equals(this.lookupVariant)) {
            return this.getParameter("connectionName");
        }
        return null;
    }

    WebServicesJmsConfig.JmsEndpointConfig getConfiguration(WebServicesJmsConfig webServicesJmsConfig) {
        if (this.endpointName != null) {
            return webServicesJmsConfig.getEndpoints().get(this.endpointName);
        }
        return new WebServicesJmsConfig.JmsEndpointConfig();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SoapJmsUri that = (SoapJmsUri)o;
        return this.uri2string.equals(that.uri2string);
    }

    public int hashCode() {
        return this.uri2string.hashCode();
    }
}

