/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.inject.MembersInjector;
import javax.inject.Inject;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.seedstack.seed.SeedException;
import org.seedstack.shed.exception.ErrorCode;
import org.seedstack.ws.jms.internal.JmsAdapter;
import org.seedstack.ws.jms.internal.SoapJmsUri;
import org.seedstack.ws.jms.internal.WSJmsErrorCodes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WSJmsMessageListener
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(WSJmsMessageListener.class);
    private final JmsAdapter adapter;
    private final SoapJmsUri soapJmsUri;
    private final Session session;
    private final boolean isTransacted;

    WSJmsMessageListener(SoapJmsUri soapJmsUri, JmsAdapter adapter, Session session) {
        this.adapter = adapter;
        this.soapJmsUri = soapJmsUri;
        this.session = session;
        try {
            this.isTransacted = session.getTransacted();
        }
        catch (JMSException e) {
            throw SeedException.wrap((Throwable)e, (ErrorCode)WSJmsErrorCodes.UNABLE_TO_GET_TRANSACTED_STATUS);
        }
    }

    @Inject
    private void injectAdapter(MembersInjector<JmsAdapter> jmsAdapterMembersInjector) {
        jmsAdapterMembersInjector.injectMembers((Object)this.adapter);
    }

    public void onMessage(Message message) {
        block5: {
            try {
                this.adapter.handle(message, this.soapJmsUri);
                if (this.isTransacted) {
                    this.session.commit();
                }
            }
            catch (Exception e) {
                LOGGER.error("An exception occurred during WS JMS message handling", (Throwable)e);
                if (!this.isTransacted) break block5;
                try {
                    this.session.rollback();
                }
                catch (JMSException e1) {
                    throw SeedException.wrap((Throwable)e, (ErrorCode)WSJmsErrorCodes.UNABLE_TO_ROLLBACK_WS_JMS_MESSAGE);
                }
            }
        }
    }
}

