/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.common.cache.LoadingCache;
import com.google.inject.PrivateModule;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.util.Set;
import javax.jms.Connection;
import org.seedstack.ws.jms.internal.JmsTransportTubeFactory;
import org.seedstack.ws.jms.internal.SoapJmsUri;
import org.seedstack.ws.jms.internal.WSJmsMessageListener;
import org.seedstack.ws.jms.internal.WSJmsTransportFactory;

class WSJmsModule
extends PrivateModule {
    private final Set<WSJmsMessageListener> wsJmsMessageListeners;
    private final LoadingCache<SoapJmsUri, Connection> connectionCache;

    WSJmsModule(Set<WSJmsMessageListener> wsJmsMessageListeners, LoadingCache<SoapJmsUri, Connection> connectionCache) {
        this.wsJmsMessageListeners = wsJmsMessageListeners;
        this.connectionCache = connectionCache;
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(WSJmsTransportFactory.class));
        this.bind((TypeLiteral)new TypeLiteral<LoadingCache<SoapJmsUri, Connection>>(){}).toInstance(this.connectionCache);
        for (WSJmsMessageListener wsJmsMessageListener : this.wsJmsMessageListeners) {
            this.requestInjection(wsJmsMessageListener);
        }
        this.requestStaticInjection(new Class[]{JmsTransportTubeFactory.class});
    }
}

