/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.jms.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.api.plugin.context.InitContext;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.naming.NamingException;
import org.apache.commons.lang.StringUtils;
import org.seedstack.jms.internal.JmsPlugin;
import org.seedstack.jms.spi.ConnectionDefinition;
import org.seedstack.jms.spi.JmsFactory;
import org.seedstack.jms.spi.MessageListenerDefinition;
import org.seedstack.jms.spi.MessageListenerInstanceDefinition;
import org.seedstack.seed.SeedException;
import org.seedstack.seed.core.internal.AbstractSeedPlugin;
import org.seedstack.shed.exception.ErrorCode;
import org.seedstack.ws.internal.EndpointDefinition;
import org.seedstack.ws.internal.WSPlugin;
import org.seedstack.ws.jms.WebServicesJmsConfig;
import org.seedstack.ws.jms.internal.JmsAdapter;
import org.seedstack.ws.jms.internal.SoapJmsUri;
import org.seedstack.ws.jms.internal.WSJmsErrorCodes;
import org.seedstack.ws.jms.internal.WSJmsMessageListener;
import org.seedstack.ws.jms.internal.WSJmsModule;

public class WSJmsPlugin
extends AbstractSeedPlugin {
    private static final List<String> SUPPORTED_BINDINGS = ImmutableList.of((Object)"http://www.w3.org/2010/soapjms/");
    private static final String LISTENER_NAME_PATTERN = "ws-%s-listener";
    private static final String ANONYMOUS_CONNECTION_PATTERN = "ws-anon-connection-%d";
    private final Set<WSJmsMessageListener> wsJmsMessageListeners = new HashSet<WSJmsMessageListener>();
    private LoadingCache<SoapJmsUri, Connection> connectionCache;
    private JmsPlugin jmsPlugin;

    public String name() {
        return "wsJms";
    }

    public Collection<Class<?>> dependencies() {
        return Lists.newArrayList((Object[])new Class[]{WSPlugin.class, JmsPlugin.class});
    }

    public InitState initialize(InitContext initContext) {
        this.jmsPlugin = (JmsPlugin)initContext.dependency(JmsPlugin.class);
        WSPlugin wsPlugin = (WSPlugin)initContext.dependency(WSPlugin.class);
        final WebServicesJmsConfig webServicesJmsConfig = (WebServicesJmsConfig)this.getConfiguration(WebServicesJmsConfig.class, new String[0]);
        WebServicesJmsConfig.JmsConfig.CacheConfig cacheConfig = webServicesJmsConfig.jms().connectionCache();
        int cacheSize = cacheConfig.getMaxSize();
        this.connectionCache = CacheBuilder.newBuilder().maximumSize((long)cacheSize).concurrencyLevel(cacheConfig.getConcurrencyLevel()).initialCapacity(cacheConfig.getInitialSize()).build((CacheLoader)new CacheLoader<SoapJmsUri, Connection>(){
            private AtomicInteger atomicInteger = new AtomicInteger(0);

            public Connection load(SoapJmsUri soapJmsUri) throws NamingException, JMSException {
                Connection connection;
                String lookupVariant = soapJmsUri.getLookupVariant();
                JmsFactory jmsFactory = WSJmsPlugin.this.jmsPlugin.getJmsFactory();
                if ("jndi".equals(lookupVariant)) {
                    String jndiConnectionFactoryName = soapJmsUri.getParameter("jndiConnectionFactoryName");
                    if (StringUtils.isBlank((String)jndiConnectionFactoryName)) {
                        throw new IllegalArgumentException("Missing jndiConnectionFactoryName parameter for JMS URI " + soapJmsUri.toString());
                    }
                    String connectionName = soapJmsUri.getConnectionName();
                    if (connectionName == null) {
                        connectionName = String.format(WSJmsPlugin.ANONYMOUS_CONNECTION_PATTERN, this.atomicInteger.getAndIncrement());
                    }
                    ConnectionDefinition connectionDefinition = jmsFactory.createConnectionDefinition(connectionName, soapJmsUri.getConfiguration(webServicesJmsConfig).jms().getConnection(), (ConnectionFactory)SoapJmsUri.getContext(soapJmsUri).lookup(jndiConnectionFactoryName));
                    connection = jmsFactory.createConnection(connectionDefinition);
                    WSJmsPlugin.this.jmsPlugin.registerConnection(connection, connectionDefinition);
                } else if ("queue".equals(lookupVariant) || "topic".equals(lookupVariant)) {
                    String connectionName = soapJmsUri.getConnectionName();
                    if (StringUtils.isBlank((String)connectionName)) {
                        throw new IllegalArgumentException("Missing connectionName parameter for JMS URI " + soapJmsUri.toString());
                    }
                    connection = WSJmsPlugin.this.jmsPlugin.getConnection(connectionName);
                } else {
                    throw new IllegalArgumentException("Unsupported lookup variant " + lookupVariant + " for JMS URI " + soapJmsUri.toString());
                }
                if (connection == null) {
                    throw new PluginException("Unable to resolve connection for JMS URI " + soapJmsUri.toString(), new Object[0]);
                }
                return connection;
            }
        });
        for (Map.Entry endpointEntry : wsPlugin.getEndpointDefinitions(SUPPORTED_BINDINGS).entrySet()) {
            Destination destination;
            Session session;
            Connection connection;
            SoapJmsUri uri;
            EndpointDefinition endpointDefinition = (EndpointDefinition)endpointEntry.getValue();
            String endpointName = (String)endpointEntry.getKey();
            String serviceName = endpointDefinition.getServiceName().getLocalPart();
            String portName = endpointDefinition.getPortName().getLocalPart();
            String serviceNameAndServicePort = serviceName + "-" + portName;
            try {
                uri = SoapJmsUri.parse(new URI(endpointDefinition.getUrl()));
                uri.setEndpointName(endpointName);
            }
            catch (URISyntaxException e) {
                throw new PluginException("Unable to parse endpoint URI", (Throwable)e);
            }
            WebServicesJmsConfig.JmsEndpointConfig endpointConfiguration = uri.getConfiguration(webServicesJmsConfig);
            try {
                connection = (Connection)this.connectionCache.get((Object)uri);
            }
            catch (Exception e) {
                throw new PluginException("Unable to create JMS connection for WS " + serviceNameAndServicePort, (Throwable)e);
            }
            try {
                session = connection.createSession(endpointConfiguration.jms().isTransactional(), 1);
            }
            catch (JMSException e) {
                throw new PluginException("Unable to create JMS session for WS " + serviceNameAndServicePort, (Throwable)e);
            }
            try {
                destination = SoapJmsUri.getDestination(uri, session);
            }
            catch (Exception e) {
                throw new PluginException("Unable to create JMS destination for WS " + serviceNameAndServicePort, (Throwable)e);
            }
            WSJmsMessageListener messageListener = new WSJmsMessageListener(uri, new JmsAdapter(wsPlugin.createWSEndpoint(endpointDefinition, null)), session);
            String messageListenerName = String.format(LISTENER_NAME_PATTERN, endpointName);
            try {
                this.jmsPlugin.registerMessageListener((MessageListenerDefinition)new MessageListenerInstanceDefinition(messageListenerName, uri.getConnectionName(), session, destination, endpointConfiguration.jms().getSelector(), (MessageListener)messageListener, endpointConfiguration.jms().getMessagePoller()));
            }
            catch (Exception e) {
                throw SeedException.wrap((Throwable)e, (ErrorCode)WSJmsErrorCodes.UNABLE_TO_REGISTER_MESSAGE_LISTENER).put("messageListenerName", (Object)messageListenerName);
            }
            this.wsJmsMessageListeners.add(messageListener);
        }
        return InitState.INITIALIZED;
    }

    public Object nativeUnitModule() {
        return new WSJmsModule(this.wsJmsMessageListeners, this.connectionCache);
    }

    public void stop() {
        if (this.connectionCache != null) {
            this.connectionCache.invalidateAll();
            this.connectionCache.cleanUp();
        }
    }
}

