/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.web.internal;

import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.server.BoundEndpoint;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.transport.http.servlet.ServletModule;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.xml.ws.WebServiceException;
import org.seedstack.shed.ClassLoaders;

class SeedServletContainer
extends Container {
    private static final String SECURITY_SERVER_TUBE_CLASS_NAME = "com.sun.xml.wss.jaxws.impl.SecurityServerTube";
    private static final String WSIT_SERVER_AUTH_CONTEXT_CLASS_NAME = "com.sun.xml.wss.provider.wsit.WSITServerAuthContext";
    private static final String GET_REALM_AUTHENTICATION_ADAPTER_METHOD_NAME = "getRealmAuthenticationAdapter";
    private final ServletContext servletContext;
    private final ServletModule module = new ServletModule(){
        private final List<BoundEndpoint> endpoints = new ArrayList<BoundEndpoint>();

        public List<BoundEndpoint> getBoundEndpoints() {
            return this.endpoints;
        }

        public String getContextPath() {
            throw new WebServiceException("Container " + SeedServletContainer.class.getName() + " doesn't support getContextPath()");
        }
    };
    private final ResourceLoader loader = new ResourceLoader(){

        public URL getResource(String resource) throws MalformedURLException {
            return SeedServletContainer.this.servletContext.getResource("/WEB-INF/" + resource);
        }
    };

    SeedServletContainer(ServletContext servletContext) {
        this.servletContext = "org.apache.catalina.core.StandardContext$NoPluggabilityServletContext".equals(servletContext.getClass().getName()) ? (ServletContext)Proxy.newProxyInstance(ClassLoaders.findMostCompleteClassLoader(SeedServletContainer.class), new Class[]{ServletContext.class}, (InvocationHandler)new ServletContextProxy(servletContext)) : servletContext;
    }

    public <T> T getSPI(Class<T> spiType) {
        if (spiType == ServletContext.class) {
            if (this.isCalledForRealmAuthenticationAdapter(this.findCaller())) {
                return null;
            }
            return spiType.cast(this.servletContext);
        }
        if (spiType.isAssignableFrom(ServletModule.class)) {
            return spiType.cast(this.module);
        }
        if (spiType == ResourceLoader.class) {
            return spiType.cast(this.loader);
        }
        return null;
    }

    private boolean isCalledForRealmAuthenticationAdapter(StackTraceElement stackTrace) {
        return stackTrace != null && (WSIT_SERVER_AUTH_CONTEXT_CLASS_NAME.equals(stackTrace.getClassName()) || SECURITY_SERVER_TUBE_CLASS_NAME.equals(stackTrace.getClassName())) && GET_REALM_AUTHENTICATION_ADAPTER_METHOD_NAME.equals(stackTrace.getMethodName());
    }

    private StackTraceElement findCaller() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            if (stackTraceElement.getClassName().equals(Thread.class.getCanonicalName()) || stackTraceElement.getClassName().equals(((Object)((Object)this)).getClass().getCanonicalName())) continue;
            return stackTraceElement;
        }
        return null;
    }

    private static class ServletContextProxy
    implements InvocationHandler {
        private final ServletContext servletContext;

        private ServletContextProxy(ServletContext servletContext) {
            this.servletContext = servletContext;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke((Object)this.servletContext, args);
        }
    }
}

