/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.ws.web.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.transport.http.servlet.ServletAdapter;
import com.sun.xml.ws.transport.http.servlet.ServletAdapterList;
import com.sun.xml.ws.transport.http.servlet.WSServlet;
import com.sun.xml.ws.transport.http.servlet.WSServletDelegate;
import io.nuun.kernel.api.plugin.InitState;
import io.nuun.kernel.api.plugin.PluginException;
import io.nuun.kernel.api.plugin.context.Context;
import io.nuun.kernel.api.plugin.context.InitContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.seedstack.seed.core.SeedRuntime;
import org.seedstack.seed.core.internal.AbstractSeedPlugin;
import org.seedstack.seed.web.spi.FilterDefinition;
import org.seedstack.seed.web.spi.ListenerDefinition;
import org.seedstack.seed.web.spi.ServletDefinition;
import org.seedstack.seed.web.spi.WebProvider;
import org.seedstack.ws.internal.EndpointDefinition;
import org.seedstack.ws.internal.WSPlugin;
import org.seedstack.ws.web.internal.SeedServletContainer;
import org.seedstack.ws.web.internal.WSWebModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSWebPlugin
extends AbstractSeedPlugin
implements WebProvider {
    private static final List<String> SUPPORTED_BINDINGS = ImmutableList.of((Object)"http://schemas.xmlsoap.org/wsdl/soap/http", (Object)"http://www.w3.org/2003/05/soap/bindings/HTTP/", (Object)"http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true", (Object)"http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true");
    private static final Logger LOGGER = LoggerFactory.getLogger(WSWebPlugin.class);
    private final Map<String, EndpointDefinition> endpointDefinitions = new HashMap<String, EndpointDefinition>();
    private final List<String> endpointUrls = new ArrayList<String>();
    private WSPlugin wsPlugin;
    private ServletContext servletContext;
    private ServletAdapterList servletAdapters;
    private WSServletDelegate wsServletDelegate;
    private WSWebModule wsWebModule;

    public String name() {
        return "ws-web";
    }

    public Collection<Class<?>> dependencies() {
        return Lists.newArrayList((Object[])new Class[]{WSPlugin.class});
    }

    public void setup(SeedRuntime seedRuntime) {
        this.servletContext = (ServletContext)seedRuntime.contextAs(ServletContext.class);
    }

    public InitState initialize(InitContext initContext) {
        this.wsPlugin = (WSPlugin)initContext.dependency(WSPlugin.class);
        this.wsPlugin.disableEndpointPublishing();
        if (this.servletContext != null) {
            for (Map.Entry wsEndpointEntry : this.wsPlugin.getEndpointDefinitions(SUPPORTED_BINDINGS).entrySet()) {
                String endpointName = (String)wsEndpointEntry.getKey();
                EndpointDefinition endpointDefinition = (EndpointDefinition)wsEndpointEntry.getValue();
                String urlString = endpointDefinition.getUrl();
                if (urlString == null || urlString.isEmpty()) {
                    throw new PluginException("url property is mandatory for WS endpoint {}", new Object[]{endpointName});
                }
                this.endpointUrls.add(urlString);
                this.endpointDefinitions.put(endpointName, endpointDefinition);
            }
            this.wsWebModule = new WSWebModule();
        }
        return InitState.INITIALIZED;
    }

    public Object nativeUnitModule() {
        return this.wsWebModule;
    }

    public void start(Context context) {
        if (this.servletContext != null) {
            this.servletAdapters = new ServletAdapterList(this.servletContext);
            for (Map.Entry<String, EndpointDefinition> endpointDefinitionEntry : this.endpointDefinitions.entrySet()) {
                LOGGER.info("Exposing WS endpoint {} on {}", (Object)endpointDefinitionEntry.getKey(), (Object)endpointDefinitionEntry.getValue().getUrl());
                this.servletAdapters.createAdapter(endpointDefinitionEntry.getKey(), endpointDefinitionEntry.getValue().getUrl(), this.wsPlugin.createWSEndpoint(endpointDefinitionEntry.getValue(), (Container)new SeedServletContainer(this.servletContext)));
            }
            this.wsServletDelegate = new WSServletDelegate((List)this.servletAdapters, this.servletContext);
            this.servletContext.setAttribute("com.sun.xml.ws.server.http.servletDelegate", (Object)this.wsServletDelegate);
        }
    }

    public void stop() {
        if (this.wsServletDelegate != null) {
            this.wsServletDelegate.destroy();
        }
        if (this.servletAdapters != null) {
            for (ServletAdapter servletAdapter : this.servletAdapters) {
                LOGGER.info("Disposing WS endpoint {}", (Object)servletAdapter.getName());
                servletAdapter.getEndpoint().dispose();
            }
        }
    }

    public List<ServletDefinition> servlets() {
        ServletDefinition wsServlet = new ServletDefinition("ws-metro", WSServlet.class);
        wsServlet.setAsyncSupported(true);
        for (String endpointUrl : this.endpointUrls) {
            wsServlet.addMappings(new String[]{endpointUrl});
        }
        return Lists.newArrayList((Object[])new ServletDefinition[]{wsServlet});
    }

    public List<FilterDefinition> filters() {
        return null;
    }

    public List<ListenerDefinition> listeners() {
        return null;
    }
}

